<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderDetailData StructType
 * @subpackage Structs
 */
class OrderDetailData extends AbstractStructBase
{
    /**
     * The id
     * @var int
     */
    public $id;
    /**
     * The orderNumber
     * @var string
     */
    public $orderNumber;
    /**
     * The buyer
     * @var \StructType\BuyerWithTaxFields
     */
    public $buyer;
    /**
     * The citizenshipId
     * @var string
     */
    public $citizenshipId;
    /**
     * The invoiceType
     * @var string
     */
    public $invoiceType;
    /**
     * The itemList
     * @var \StructType\OrderItemDataList
     */
    public $itemList;
    /**
     * The serviceItemList
     * @var \StructType\ServiceOrderItemDataList
     */
    public $serviceItemList;
    /**
     * The status
     * @var int
     */
    public $status;
    /**
     * The paymentType
     * @var int
     */
    public $paymentType;
    /**
     * The billingTemplate
     * @var \StructType\BillingTemplate
     */
    public $billingTemplate;
    /**
     * The shippingAddress
     * @var \StructType\AddressModel
     */
    public $shippingAddress;
    /**
     * The billingAddress
     * @var \StructType\AddressModel
     */
    public $billingAddress;
    /**
     * The createDate
     * @var string
     */
    public $createDate;
    /**
     * Constructor method for OrderDetailData
     * @uses OrderDetailData::setId()
     * @uses OrderDetailData::setOrderNumber()
     * @uses OrderDetailData::setBuyer()
     * @uses OrderDetailData::setCitizenshipId()
     * @uses OrderDetailData::setInvoiceType()
     * @uses OrderDetailData::setItemList()
     * @uses OrderDetailData::setServiceItemList()
     * @uses OrderDetailData::setStatus()
     * @uses OrderDetailData::setPaymentType()
     * @uses OrderDetailData::setBillingTemplate()
     * @uses OrderDetailData::setShippingAddress()
     * @uses OrderDetailData::setBillingAddress()
     * @uses OrderDetailData::setCreateDate()
     * @param int $id
     * @param string $orderNumber
     * @param \StructType\BuyerWithTaxFields $buyer
     * @param string $citizenshipId
     * @param string $invoiceType
     * @param \StructType\OrderItemDataList $itemList
     * @param \StructType\ServiceOrderItemDataList $serviceItemList
     * @param int $status
     * @param int $paymentType
     * @param \StructType\BillingTemplate $billingTemplate
     * @param \StructType\AddressModel $shippingAddress
     * @param \StructType\AddressModel $billingAddress
     * @param string $createDate
     */
    public function __construct($id = null, $orderNumber = null, \StructType\BuyerWithTaxFields $buyer = null, $citizenshipId = null, $invoiceType = null, \StructType\OrderItemDataList $itemList = null, \StructType\ServiceOrderItemDataList $serviceItemList = null, $status = null, $paymentType = null, \StructType\BillingTemplate $billingTemplate = null, \StructType\AddressModel $shippingAddress = null, \StructType\AddressModel $billingAddress = null, $createDate = null)
    {
        $this
            ->setId($id)
            ->setOrderNumber($orderNumber)
            ->setBuyer($buyer)
            ->setCitizenshipId($citizenshipId)
            ->setInvoiceType($invoiceType)
            ->setItemList($itemList)
            ->setServiceItemList($serviceItemList)
            ->setStatus($status)
            ->setPaymentType($paymentType)
            ->setBillingTemplate($billingTemplate)
            ->setShippingAddress($shippingAddress)
            ->setBillingAddress($billingAddress)
            ->setCreateDate($createDate);
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\OrderDetailData
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get orderNumber value
     * @return string|null
     */
    public function getOrderNumber()
    {
        return $this->orderNumber;
    }
    /**
     * Set orderNumber value
     * @param string $orderNumber
     * @return \StructType\OrderDetailData
     */
    public function setOrderNumber($orderNumber = null)
    {
        // validation for constraint: string
        if (!is_null($orderNumber) && !is_string($orderNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderNumber, true), gettype($orderNumber)), __LINE__);
        }
        $this->orderNumber = $orderNumber;
        return $this;
    }
    /**
     * Get buyer value
     * @return \StructType\BuyerWithTaxFields|null
     */
    public function getBuyer()
    {
        return $this->buyer;
    }
    /**
     * Set buyer value
     * @param \StructType\BuyerWithTaxFields $buyer
     * @return \StructType\OrderDetailData
     */
    public function setBuyer(\StructType\BuyerWithTaxFields $buyer = null)
    {
        $this->buyer = $buyer;
        return $this;
    }
    /**
     * Get citizenshipId value
     * @return string|null
     */
    public function getCitizenshipId()
    {
        return $this->citizenshipId;
    }
    /**
     * Set citizenshipId value
     * @param string $citizenshipId
     * @return \StructType\OrderDetailData
     */
    public function setCitizenshipId($citizenshipId = null)
    {
        // validation for constraint: string
        if (!is_null($citizenshipId) && !is_string($citizenshipId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($citizenshipId, true), gettype($citizenshipId)), __LINE__);
        }
        $this->citizenshipId = $citizenshipId;
        return $this;
    }
    /**
     * Get invoiceType value
     * @return string|null
     */
    public function getInvoiceType()
    {
        return $this->invoiceType;
    }
    /**
     * Set invoiceType value
     * @param string $invoiceType
     * @return \StructType\OrderDetailData
     */
    public function setInvoiceType($invoiceType = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceType) && !is_string($invoiceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceType, true), gettype($invoiceType)), __LINE__);
        }
        $this->invoiceType = $invoiceType;
        return $this;
    }
    /**
     * Get itemList value
     * @return \StructType\OrderItemDataList|null
     */
    public function getItemList()
    {
        return $this->itemList;
    }
    /**
     * Set itemList value
     * @param \StructType\OrderItemDataList $itemList
     * @return \StructType\OrderDetailData
     */
    public function setItemList(\StructType\OrderItemDataList $itemList = null)
    {
        $this->itemList = $itemList;
        return $this;
    }
    /**
     * Get serviceItemList value
     * @return \StructType\ServiceOrderItemDataList|null
     */
    public function getServiceItemList()
    {
        return $this->serviceItemList;
    }
    /**
     * Set serviceItemList value
     * @param \StructType\ServiceOrderItemDataList $serviceItemList
     * @return \StructType\OrderDetailData
     */
    public function setServiceItemList(\StructType\ServiceOrderItemDataList $serviceItemList = null)
    {
        $this->serviceItemList = $serviceItemList;
        return $this;
    }
    /**
     * Get status value
     * @return int|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param int $status
     * @return \StructType\OrderDetailData
     */
    public function setStatus($status = null)
    {
        // validation for constraint: int
        if (!is_null($status) && !(is_int($status) || ctype_digit($status))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get paymentType value
     * @return int|null
     */
    public function getPaymentType()
    {
        return $this->paymentType;
    }
    /**
     * Set paymentType value
     * @param int $paymentType
     * @return \StructType\OrderDetailData
     */
    public function setPaymentType($paymentType = null)
    {
        // validation for constraint: int
        if (!is_null($paymentType) && !(is_int($paymentType) || ctype_digit($paymentType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($paymentType, true), gettype($paymentType)), __LINE__);
        }
        $this->paymentType = $paymentType;
        return $this;
    }
    /**
     * Get billingTemplate value
     * @return \StructType\BillingTemplate|null
     */
    public function getBillingTemplate()
    {
        return $this->billingTemplate;
    }
    /**
     * Set billingTemplate value
     * @param \StructType\BillingTemplate $billingTemplate
     * @return \StructType\OrderDetailData
     */
    public function setBillingTemplate(\StructType\BillingTemplate $billingTemplate = null)
    {
        $this->billingTemplate = $billingTemplate;
        return $this;
    }
    /**
     * Get shippingAddress value
     * @return \StructType\AddressModel|null
     */
    public function getShippingAddress()
    {
        return $this->shippingAddress;
    }
    /**
     * Set shippingAddress value
     * @param \StructType\AddressModel $shippingAddress
     * @return \StructType\OrderDetailData
     */
    public function setShippingAddress(\StructType\AddressModel $shippingAddress = null)
    {
        $this->shippingAddress = $shippingAddress;
        return $this;
    }
    /**
     * Get billingAddress value
     * @return \StructType\AddressModel|null
     */
    public function getBillingAddress()
    {
        return $this->billingAddress;
    }
    /**
     * Set billingAddress value
     * @param \StructType\AddressModel $billingAddress
     * @return \StructType\OrderDetailData
     */
    public function setBillingAddress(\StructType\AddressModel $billingAddress = null)
    {
        $this->billingAddress = $billingAddress;
        return $this;
    }
    /**
     * Get createDate value
     * @return string|null
     */
    public function getCreateDate()
    {
        return $this->createDate;
    }
    /**
     * Set createDate value
     * @param string $createDate
     * @return \StructType\OrderDetailData
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createDate, true), gettype($createDate)), __LINE__);
        }
        $this->createDate = $createDate;
        return $this;
    }
}
