<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderDetailRequest StructType
 * @subpackage Structs
 */
class OrderDetailRequest extends AbstractStructBase
{
    /**
     * The auth
     * @var \StructType\Authentication
     */
    public $auth;
    /**
     * The orderRequest
     * @var \StructType\OrderDataRequest
     */
    public $orderRequest;
    /**
     * Constructor method for OrderDetailRequest
     * @uses OrderDetailRequest::setAuth()
     * @uses OrderDetailRequest::setOrderRequest()
     * @param \StructType\Authentication $auth
     * @param \StructType\OrderDataRequest $orderRequest
     */
    public function __construct(\StructType\Authentication $auth = null, \StructType\OrderDataRequest $orderRequest = null)
    {
        $this
            ->setAuth($auth)
            ->setOrderRequest($orderRequest);
    }
    /**
     * Get auth value
     * @return \StructType\Authentication|null
     */
    public function getAuth()
    {
        return $this->auth;
    }
    /**
     * Set auth value
     * @param \StructType\Authentication $auth
     * @return \StructType\OrderDetailRequest
     */
    public function setAuth(\StructType\Authentication $auth = null)
    {
        $this->auth = $auth;
        return $this;
    }
    /**
     * Get orderRequest value
     * @return \StructType\OrderDataRequest|null
     */
    public function getOrderRequest()
    {
        return $this->orderRequest;
    }
    /**
     * Set orderRequest value
     * @param \StructType\OrderDataRequest $orderRequest
     * @return \StructType\OrderDetailRequest
     */
    public function setOrderRequest(\StructType\OrderDataRequest $orderRequest = null)
    {
        $this->orderRequest = $orderRequest;
        return $this;
    }
}
