<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderDataList StructType
 * @subpackage Structs
 */
class OrderDataList extends AbstractStructBase
{
    /**
     * The order
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OrderData[]
     */
    public $order;
    /**
     * Constructor method for OrderDataList
     * @uses OrderDataList::setOrder()
     * @param \StructType\OrderData[] $order
     */
    public function __construct(array $order = array())
    {
        $this
            ->setOrder($order);
    }
    /**
     * Get order value
     * @return \StructType\OrderData[]|null
     */
    public function getOrder()
    {
        return $this->order;
    }
    /**
     * This method is responsible for validating the values passed to the setOrder method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrder method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrderForArrayConstraintsFromSetOrder(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $orderDataListOrderItem) {
            // validation for constraint: itemType
            if (!$orderDataListOrderItem instanceof \StructType\OrderData) {
                $invalidValues[] = is_object($orderDataListOrderItem) ? get_class($orderDataListOrderItem) : sprintf('%s(%s)', gettype($orderDataListOrderItem), var_export($orderDataListOrderItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The order property can only contain items of type \StructType\OrderData, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set order value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderData[] $order
     * @return \StructType\OrderDataList
     */
    public function setOrder(array $order = array())
    {
        // validation for constraint: array
        if ('' !== ($orderArrayErrorMessage = self::validateOrderForArrayConstraintsFromSetOrder($order))) {
            throw new \InvalidArgumentException($orderArrayErrorMessage, __LINE__);
        }
        $this->order = $order;
        return $this;
    }
    /**
     * Add item to order value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderData $item
     * @return \StructType\OrderDataList
     */
    public function addToOrder(\StructType\OrderData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrderData) {
            throw new \InvalidArgumentException(sprintf('The order property can only contain items of type \StructType\OrderData, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->order[] = $item;
        return $this;
    }
}
