<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Separate ServiceType
 * @subpackage Services
 */
class Separate extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SeparateCombinedItems
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SeparateCombinedItemsRequest $separateCombinedItemsRequest
     * @return \StructType\SeparateCombinedItemsResponse|bool
     */
    public function SeparateCombinedItems(\StructType\SeparateCombinedItemsRequest $separateCombinedItemsRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->SeparateCombinedItems($separateCombinedItemsRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SeparateCombinedItemsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
