<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BillingTemplate StructType
 * @subpackage Structs
 */
class BillingTemplate extends AbstractStructBase
{
    /**
     * The originalPrice
     * @var float
     */
    public $originalPrice;
    /**
     * The totalSellerDiscount
     * @var float
     */
    public $totalSellerDiscount;
    /**
     * The totalServiceItemOriginalPrice
     * @var float
     */
    public $totalServiceItemOriginalPrice;
    /**
     * The installmentChargeWithVat
     * @var float
     */
    public $installmentChargeWithVat;
    /**
     * The sellerInvoiceAmount
     * @var float
     */
    public $sellerInvoiceAmount;
    /**
     * The totalMallDiscountPrice
     * @var float
     */
    public $totalMallDiscountPrice;
    /**
     * The dueAmount
     * @var float
     */
    public $dueAmount;
    /**
     * Constructor method for BillingTemplate
     * @uses BillingTemplate::setOriginalPrice()
     * @uses BillingTemplate::setTotalSellerDiscount()
     * @uses BillingTemplate::setTotalServiceItemOriginalPrice()
     * @uses BillingTemplate::setInstallmentChargeWithVat()
     * @uses BillingTemplate::setSellerInvoiceAmount()
     * @uses BillingTemplate::setTotalMallDiscountPrice()
     * @uses BillingTemplate::setDueAmount()
     * @param float $originalPrice
     * @param float $totalSellerDiscount
     * @param float $totalServiceItemOriginalPrice
     * @param float $installmentChargeWithVat
     * @param float $sellerInvoiceAmount
     * @param float $totalMallDiscountPrice
     * @param float $dueAmount
     */
    public function __construct($originalPrice = null, $totalSellerDiscount = null, $totalServiceItemOriginalPrice = null, $installmentChargeWithVat = null, $sellerInvoiceAmount = null, $totalMallDiscountPrice = null, $dueAmount = null)
    {
        $this
            ->setOriginalPrice($originalPrice)
            ->setTotalSellerDiscount($totalSellerDiscount)
            ->setTotalServiceItemOriginalPrice($totalServiceItemOriginalPrice)
            ->setInstallmentChargeWithVat($installmentChargeWithVat)
            ->setSellerInvoiceAmount($sellerInvoiceAmount)
            ->setTotalMallDiscountPrice($totalMallDiscountPrice)
            ->setDueAmount($dueAmount);
    }
    /**
     * Get originalPrice value
     * @return float|null
     */
    public function getOriginalPrice()
    {
        return $this->originalPrice;
    }
    /**
     * Set originalPrice value
     * @param float $originalPrice
     * @return \StructType\BillingTemplate
     */
    public function setOriginalPrice($originalPrice = null)
    {
        // validation for constraint: float
        if (!is_null($originalPrice) && !(is_float($originalPrice) || is_numeric($originalPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($originalPrice, true), gettype($originalPrice)), __LINE__);
        }
        $this->originalPrice = $originalPrice;
        return $this;
    }
    /**
     * Get totalSellerDiscount value
     * @return float|null
     */
    public function getTotalSellerDiscount()
    {
        return $this->totalSellerDiscount;
    }
    /**
     * Set totalSellerDiscount value
     * @param float $totalSellerDiscount
     * @return \StructType\BillingTemplate
     */
    public function setTotalSellerDiscount($totalSellerDiscount = null)
    {
        // validation for constraint: float
        if (!is_null($totalSellerDiscount) && !(is_float($totalSellerDiscount) || is_numeric($totalSellerDiscount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalSellerDiscount, true), gettype($totalSellerDiscount)), __LINE__);
        }
        $this->totalSellerDiscount = $totalSellerDiscount;
        return $this;
    }
    /**
     * Get totalServiceItemOriginalPrice value
     * @return float|null
     */
    public function getTotalServiceItemOriginalPrice()
    {
        return $this->totalServiceItemOriginalPrice;
    }
    /**
     * Set totalServiceItemOriginalPrice value
     * @param float $totalServiceItemOriginalPrice
     * @return \StructType\BillingTemplate
     */
    public function setTotalServiceItemOriginalPrice($totalServiceItemOriginalPrice = null)
    {
        // validation for constraint: float
        if (!is_null($totalServiceItemOriginalPrice) && !(is_float($totalServiceItemOriginalPrice) || is_numeric($totalServiceItemOriginalPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalServiceItemOriginalPrice, true), gettype($totalServiceItemOriginalPrice)), __LINE__);
        }
        $this->totalServiceItemOriginalPrice = $totalServiceItemOriginalPrice;
        return $this;
    }
    /**
     * Get installmentChargeWithVat value
     * @return float|null
     */
    public function getInstallmentChargeWithVat()
    {
        return $this->installmentChargeWithVat;
    }
    /**
     * Set installmentChargeWithVat value
     * @param float $installmentChargeWithVat
     * @return \StructType\BillingTemplate
     */
    public function setInstallmentChargeWithVat($installmentChargeWithVat = null)
    {
        // validation for constraint: float
        if (!is_null($installmentChargeWithVat) && !(is_float($installmentChargeWithVat) || is_numeric($installmentChargeWithVat))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($installmentChargeWithVat, true), gettype($installmentChargeWithVat)), __LINE__);
        }
        $this->installmentChargeWithVat = $installmentChargeWithVat;
        return $this;
    }
    /**
     * Get sellerInvoiceAmount value
     * @return float|null
     */
    public function getSellerInvoiceAmount()
    {
        return $this->sellerInvoiceAmount;
    }
    /**
     * Set sellerInvoiceAmount value
     * @param float $sellerInvoiceAmount
     * @return \StructType\BillingTemplate
     */
    public function setSellerInvoiceAmount($sellerInvoiceAmount = null)
    {
        // validation for constraint: float
        if (!is_null($sellerInvoiceAmount) && !(is_float($sellerInvoiceAmount) || is_numeric($sellerInvoiceAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($sellerInvoiceAmount, true), gettype($sellerInvoiceAmount)), __LINE__);
        }
        $this->sellerInvoiceAmount = $sellerInvoiceAmount;
        return $this;
    }
    /**
     * Get totalMallDiscountPrice value
     * @return float|null
     */
    public function getTotalMallDiscountPrice()
    {
        return $this->totalMallDiscountPrice;
    }
    /**
     * Set totalMallDiscountPrice value
     * @param float $totalMallDiscountPrice
     * @return \StructType\BillingTemplate
     */
    public function setTotalMallDiscountPrice($totalMallDiscountPrice = null)
    {
        // validation for constraint: float
        if (!is_null($totalMallDiscountPrice) && !(is_float($totalMallDiscountPrice) || is_numeric($totalMallDiscountPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalMallDiscountPrice, true), gettype($totalMallDiscountPrice)), __LINE__);
        }
        $this->totalMallDiscountPrice = $totalMallDiscountPrice;
        return $this;
    }
    /**
     * Get dueAmount value
     * @return float|null
     */
    public function getDueAmount()
    {
        return $this->dueAmount;
    }
    /**
     * Set dueAmount value
     * @param float $dueAmount
     * @return \StructType\BillingTemplate
     */
    public function setDueAmount($dueAmount = null)
    {
        // validation for constraint: float
        if (!is_null($dueAmount) && !(is_float($dueAmount) || is_numeric($dueAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($dueAmount, true), gettype($dueAmount)), __LINE__);
        }
        $this->dueAmount = $dueAmount;
        return $this;
    }
}
