<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductOrderItemList StructType
 * @subpackage Structs
 */
class ProductOrderItemList extends AbstractStructBase
{
    /**
     * The orderItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var int[]
     */
    public $orderItem;
    /**
     * Constructor method for ProductOrderItemList
     * @uses ProductOrderItemList::setOrderItem()
     * @param int[] $orderItem
     */
    public function __construct(array $orderItem = array())
    {
        $this
            ->setOrderItem($orderItem);
    }
    /**
     * Get orderItem value
     * @return int[]|null
     */
    public function getOrderItem()
    {
        return $this->orderItem;
    }
    /**
     * This method is responsible for validating the values passed to the setOrderItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrderItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrderItemForArrayConstraintsFromSetOrderItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $productOrderItemListOrderItemItem) {
            // validation for constraint: itemType
            if (!(is_int($productOrderItemListOrderItemItem) || ctype_digit($productOrderItemListOrderItemItem))) {
                $invalidValues[] = is_object($productOrderItemListOrderItemItem) ? get_class($productOrderItemListOrderItemItem) : sprintf('%s(%s)', gettype($productOrderItemListOrderItemItem), var_export($productOrderItemListOrderItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The orderItem property can only contain items of type long, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set orderItem value
     * @throws \InvalidArgumentException
     * @param int[] $orderItem
     * @return \StructType\ProductOrderItemList
     */
    public function setOrderItem(array $orderItem = array())
    {
        // validation for constraint: array
        if ('' !== ($orderItemArrayErrorMessage = self::validateOrderItemForArrayConstraintsFromSetOrderItem($orderItem))) {
            throw new \InvalidArgumentException($orderItemArrayErrorMessage, __LINE__);
        }
        $this->orderItem = $orderItem;
        return $this;
    }
    /**
     * Add item to orderItem value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\ProductOrderItemList
     */
    public function addToOrderItem($item)
    {
        // validation for constraint: itemType
        if (!(is_int($item) || ctype_digit($item))) {
            throw new \InvalidArgumentException(sprintf('The orderItem property can only contain items of type long, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->orderItem[] = $item;
        return $this;
    }
}
