<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderItemListShipmentRequest StructType
 * @subpackage Structs
 */
class OrderItemListShipmentRequest extends AbstractStructBase
{
    /**
     * The orderItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\OrderItemShipmentRequest[]
     */
    public $orderItem;
    /**
     * Constructor method for OrderItemListShipmentRequest
     * @uses OrderItemListShipmentRequest::setOrderItem()
     * @param \StructType\OrderItemShipmentRequest[] $orderItem
     */
    public function __construct(array $orderItem = array())
    {
        $this
            ->setOrderItem($orderItem);
    }
    /**
     * Get orderItem value
     * @return \StructType\OrderItemShipmentRequest[]|null
     */
    public function getOrderItem()
    {
        return $this->orderItem;
    }
    /**
     * This method is responsible for validating the values passed to the setOrderItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrderItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrderItemForArrayConstraintsFromSetOrderItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $orderItemListShipmentRequestOrderItemItem) {
            // validation for constraint: itemType
            if (!$orderItemListShipmentRequestOrderItemItem instanceof \StructType\OrderItemShipmentRequest) {
                $invalidValues[] = is_object($orderItemListShipmentRequestOrderItemItem) ? get_class($orderItemListShipmentRequestOrderItemItem) : sprintf('%s(%s)', gettype($orderItemListShipmentRequestOrderItemItem), var_export($orderItemListShipmentRequestOrderItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The orderItem property can only contain items of type \StructType\OrderItemShipmentRequest, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set orderItem value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderItemShipmentRequest[] $orderItem
     * @return \StructType\OrderItemListShipmentRequest
     */
    public function setOrderItem(array $orderItem = array())
    {
        // validation for constraint: array
        if ('' !== ($orderItemArrayErrorMessage = self::validateOrderItemForArrayConstraintsFromSetOrderItem($orderItem))) {
            throw new \InvalidArgumentException($orderItemArrayErrorMessage, __LINE__);
        }
        $this->orderItem = $orderItem;
        return $this;
    }
    /**
     * Add item to orderItem value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderItemShipmentRequest $item
     * @return \StructType\OrderItemListShipmentRequest
     */
    public function addToOrderItem(\StructType\OrderItemShipmentRequest $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrderItemShipmentRequest) {
            throw new \InvalidArgumentException(sprintf('The orderItem property can only contain items of type \StructType\OrderItemShipmentRequest, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->orderItem[] = $item;
        return $this;
    }
}
