<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderItemDataList StructType
 * @subpackage Structs
 */
class OrderItemDataList extends AbstractStructBase
{
    /**
     * The item
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\OrderSearchData[]
     */
    public $item;
    /**
     * Constructor method for OrderItemDataList
     * @uses OrderItemDataList::setItem()
     * @param \StructType\OrderSearchData[] $item
     */
    public function __construct(array $item = array())
    {
        $this
            ->setItem($item);
    }
    /**
     * Get item value
     * @return \StructType\OrderSearchData[]|null
     */
    public function getItem()
    {
        return $this->item;
    }
    /**
     * This method is responsible for validating the values passed to the setItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemForArrayConstraintsFromSetItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $orderItemDataListItemItem) {
            // validation for constraint: itemType
            if (!$orderItemDataListItemItem instanceof \StructType\OrderSearchData) {
                $invalidValues[] = is_object($orderItemDataListItemItem) ? get_class($orderItemDataListItemItem) : sprintf('%s(%s)', gettype($orderItemDataListItemItem), var_export($orderItemDataListItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The item property can only contain items of type \StructType\OrderSearchData, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set item value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderSearchData[] $item
     * @return \StructType\OrderItemDataList
     */
    public function setItem(array $item = array())
    {
        // validation for constraint: array
        if ('' !== ($itemArrayErrorMessage = self::validateItemForArrayConstraintsFromSetItem($item))) {
            throw new \InvalidArgumentException($itemArrayErrorMessage, __LINE__);
        }
        $this->item = $item;
        return $this;
    }
    /**
     * Add item to item value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderSearchData $item
     * @return \StructType\OrderItemDataList
     */
    public function addToItem(\StructType\OrderSearchData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrderSearchData) {
            throw new \InvalidArgumentException(sprintf('The item property can only contain items of type \StructType\OrderSearchData, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->item[] = $item;
        return $this;
    }
}
