<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DetailedOrderListRequest StructType
 * @subpackage Structs
 */
class DetailedOrderListRequest extends AbstractStructBase
{
    /**
     * The auth
     * @var \StructType\Authentication
     */
    public $auth;
    /**
     * The searchData
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\OrderDataListRequest
     */
    public $searchData;
    /**
     * The pagingData
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\PagingData
     */
    public $pagingData;
    /**
     * Constructor method for DetailedOrderListRequest
     * @uses DetailedOrderListRequest::setAuth()
     * @uses DetailedOrderListRequest::setSearchData()
     * @uses DetailedOrderListRequest::setPagingData()
     * @param \StructType\Authentication $auth
     * @param \StructType\OrderDataListRequest $searchData
     * @param \StructType\PagingData $pagingData
     */
    public function __construct(\StructType\Authentication $auth = null, \StructType\OrderDataListRequest $searchData = null, \StructType\PagingData $pagingData = null)
    {
        $this
            ->setAuth($auth)
            ->setSearchData($searchData)
            ->setPagingData($pagingData);
    }
    /**
     * Get auth value
     * @return \StructType\Authentication|null
     */
    public function getAuth()
    {
        return $this->auth;
    }
    /**
     * Set auth value
     * @param \StructType\Authentication $auth
     * @return \StructType\DetailedOrderListRequest
     */
    public function setAuth(\StructType\Authentication $auth = null)
    {
        $this->auth = $auth;
        return $this;
    }
    /**
     * Get searchData value
     * @return \StructType\OrderDataListRequest|null
     */
    public function getSearchData()
    {
        return $this->searchData;
    }
    /**
     * Set searchData value
     * @param \StructType\OrderDataListRequest $searchData
     * @return \StructType\DetailedOrderListRequest
     */
    public function setSearchData(\StructType\OrderDataListRequest $searchData = null)
    {
        $this->searchData = $searchData;
        return $this;
    }
    /**
     * Get pagingData value
     * @return \StructType\PagingData|null
     */
    public function getPagingData()
    {
        return $this->pagingData;
    }
    /**
     * Set pagingData value
     * @param \StructType\PagingData $pagingData
     * @return \StructType\DetailedOrderListRequest
     */
    public function setPagingData(\StructType\PagingData $pagingData = null)
    {
        $this->pagingData = $pagingData;
        return $this;
    }
}
