<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DetailedOrderData StructType
 * @subpackage Structs
 */
class DetailedOrderData extends AbstractStructBase
{
    /**
     * The id
     * @var int
     */
    public $id;
    /**
     * The invoiceType
     * @var string
     */
    public $invoiceType;
    /**
     * The status
     * @var int
     */
    public $status;
    /**
     * The orderNumber
     * @var string
     */
    public $orderNumber;
    /**
     * The totalAmount
     * @var float
     */
    public $totalAmount;
    /**
     * The paymentType
     * @var int
     */
    public $paymentType;
    /**
     * The citizenshipId
     * @var string
     */
    public $citizenshipId;
    /**
     * The orderItemList
     * @var \StructType\DetailedOrderItemDataList
     */
    public $orderItemList;
    /**
     * The createDate
     * @var string
     */
    public $createDate;
    /**
     * Constructor method for DetailedOrderData
     * @uses DetailedOrderData::setId()
     * @uses DetailedOrderData::setInvoiceType()
     * @uses DetailedOrderData::setStatus()
     * @uses DetailedOrderData::setOrderNumber()
     * @uses DetailedOrderData::setTotalAmount()
     * @uses DetailedOrderData::setPaymentType()
     * @uses DetailedOrderData::setCitizenshipId()
     * @uses DetailedOrderData::setOrderItemList()
     * @uses DetailedOrderData::setCreateDate()
     * @param int $id
     * @param string $invoiceType
     * @param int $status
     * @param string $orderNumber
     * @param float $totalAmount
     * @param int $paymentType
     * @param string $citizenshipId
     * @param \StructType\DetailedOrderItemDataList $orderItemList
     * @param string $createDate
     */
    public function __construct($id = null, $invoiceType = null, $status = null, $orderNumber = null, $totalAmount = null, $paymentType = null, $citizenshipId = null, \StructType\DetailedOrderItemDataList $orderItemList = null, $createDate = null)
    {
        $this
            ->setId($id)
            ->setInvoiceType($invoiceType)
            ->setStatus($status)
            ->setOrderNumber($orderNumber)
            ->setTotalAmount($totalAmount)
            ->setPaymentType($paymentType)
            ->setCitizenshipId($citizenshipId)
            ->setOrderItemList($orderItemList)
            ->setCreateDate($createDate);
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\DetailedOrderData
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get invoiceType value
     * @return string|null
     */
    public function getInvoiceType()
    {
        return $this->invoiceType;
    }
    /**
     * Set invoiceType value
     * @param string $invoiceType
     * @return \StructType\DetailedOrderData
     */
    public function setInvoiceType($invoiceType = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceType) && !is_string($invoiceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceType, true), gettype($invoiceType)), __LINE__);
        }
        $this->invoiceType = $invoiceType;
        return $this;
    }
    /**
     * Get status value
     * @return int|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param int $status
     * @return \StructType\DetailedOrderData
     */
    public function setStatus($status = null)
    {
        // validation for constraint: int
        if (!is_null($status) && !(is_int($status) || ctype_digit($status))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get orderNumber value
     * @return string|null
     */
    public function getOrderNumber()
    {
        return $this->orderNumber;
    }
    /**
     * Set orderNumber value
     * @param string $orderNumber
     * @return \StructType\DetailedOrderData
     */
    public function setOrderNumber($orderNumber = null)
    {
        // validation for constraint: string
        if (!is_null($orderNumber) && !is_string($orderNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderNumber, true), gettype($orderNumber)), __LINE__);
        }
        $this->orderNumber = $orderNumber;
        return $this;
    }
    /**
     * Get totalAmount value
     * @return float|null
     */
    public function getTotalAmount()
    {
        return $this->totalAmount;
    }
    /**
     * Set totalAmount value
     * @param float $totalAmount
     * @return \StructType\DetailedOrderData
     */
    public function setTotalAmount($totalAmount = null)
    {
        // validation for constraint: float
        if (!is_null($totalAmount) && !(is_float($totalAmount) || is_numeric($totalAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalAmount, true), gettype($totalAmount)), __LINE__);
        }
        $this->totalAmount = $totalAmount;
        return $this;
    }
    /**
     * Get paymentType value
     * @return int|null
     */
    public function getPaymentType()
    {
        return $this->paymentType;
    }
    /**
     * Set paymentType value
     * @param int $paymentType
     * @return \StructType\DetailedOrderData
     */
    public function setPaymentType($paymentType = null)
    {
        // validation for constraint: int
        if (!is_null($paymentType) && !(is_int($paymentType) || ctype_digit($paymentType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($paymentType, true), gettype($paymentType)), __LINE__);
        }
        $this->paymentType = $paymentType;
        return $this;
    }
    /**
     * Get citizenshipId value
     * @return string|null
     */
    public function getCitizenshipId()
    {
        return $this->citizenshipId;
    }
    /**
     * Set citizenshipId value
     * @param string $citizenshipId
     * @return \StructType\DetailedOrderData
     */
    public function setCitizenshipId($citizenshipId = null)
    {
        // validation for constraint: string
        if (!is_null($citizenshipId) && !is_string($citizenshipId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($citizenshipId, true), gettype($citizenshipId)), __LINE__);
        }
        $this->citizenshipId = $citizenshipId;
        return $this;
    }
    /**
     * Get orderItemList value
     * @return \StructType\DetailedOrderItemDataList|null
     */
    public function getOrderItemList()
    {
        return $this->orderItemList;
    }
    /**
     * Set orderItemList value
     * @param \StructType\DetailedOrderItemDataList $orderItemList
     * @return \StructType\DetailedOrderData
     */
    public function setOrderItemList(\StructType\DetailedOrderItemDataList $orderItemList = null)
    {
        $this->orderItemList = $orderItemList;
        return $this;
    }
    /**
     * Get createDate value
     * @return string|null
     */
    public function getCreateDate()
    {
        return $this->createDate;
    }
    /**
     * Set createDate value
     * @param string $createDate
     * @return \StructType\DetailedOrderData
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createDate, true), gettype($createDate)), __LINE__);
        }
        $this->createDate = $createDate;
        return $this;
    }
}
