<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemWithComplementaryList StructType
 * @subpackage Structs
 */
class ItemWithComplementaryList extends AbstractStructBase
{
    /**
     * The itemWithComplementary
     * Meta information extracted from the WSDL
     * - maxOccurs: 500
     * @var \StructType\ItemWithComplementaryData[]
     */
    public $itemWithComplementary;
    /**
     * Constructor method for ItemWithComplementaryList
     * @uses ItemWithComplementaryList::setItemWithComplementary()
     * @param \StructType\ItemWithComplementaryData[] $itemWithComplementary
     */
    public function __construct(array $itemWithComplementary = array())
    {
        $this
            ->setItemWithComplementary($itemWithComplementary);
    }
    /**
     * Get itemWithComplementary value
     * @return \StructType\ItemWithComplementaryData[]|null
     */
    public function getItemWithComplementary()
    {
        return $this->itemWithComplementary;
    }
    /**
     * This method is responsible for validating the values passed to the setItemWithComplementary method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItemWithComplementary method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemWithComplementaryForArrayConstraintsFromSetItemWithComplementary(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemWithComplementaryListItemWithComplementaryItem) {
            // validation for constraint: itemType
            if (!$itemWithComplementaryListItemWithComplementaryItem instanceof \StructType\ItemWithComplementaryData) {
                $invalidValues[] = is_object($itemWithComplementaryListItemWithComplementaryItem) ? get_class($itemWithComplementaryListItemWithComplementaryItem) : sprintf('%s(%s)', gettype($itemWithComplementaryListItemWithComplementaryItem), var_export($itemWithComplementaryListItemWithComplementaryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The itemWithComplementary property can only contain items of type \StructType\ItemWithComplementaryData, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set itemWithComplementary value
     * @throws \InvalidArgumentException
     * @param \StructType\ItemWithComplementaryData[] $itemWithComplementary
     * @return \StructType\ItemWithComplementaryList
     */
    public function setItemWithComplementary(array $itemWithComplementary = array())
    {
        // validation for constraint: array
        if ('' !== ($itemWithComplementaryArrayErrorMessage = self::validateItemWithComplementaryForArrayConstraintsFromSetItemWithComplementary($itemWithComplementary))) {
            throw new \InvalidArgumentException($itemWithComplementaryArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(500)
        if (is_array($itemWithComplementary) && count($itemWithComplementary) > 500) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 500', count($itemWithComplementary)), __LINE__);
        }
        $this->itemWithComplementary = $itemWithComplementary;
        return $this;
    }
    /**
     * Add item to itemWithComplementary value
     * @throws \InvalidArgumentException
     * @param \StructType\ItemWithComplementaryData $item
     * @return \StructType\ItemWithComplementaryList
     */
    public function addToItemWithComplementary(\StructType\ItemWithComplementaryData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ItemWithComplementaryData) {
            throw new \InvalidArgumentException(sprintf('The itemWithComplementary property can only contain items of type \StructType\ItemWithComplementaryData, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(500)
        if (is_array($this->itemWithComplementary) && count($this->itemWithComplementary) >= 500) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 500', count($this->itemWithComplementary)), __LINE__);
        }
        $this->itemWithComplementary[] = $item;
        return $this;
    }
}
