<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BaseResponse StructType
 * @subpackage Structs
 */
class BaseResponse extends AbstractStructBase
{
    /**
     * The status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $status;
    /**
     * The errorCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $errorCode;
    /**
     * The errorMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $errorMessage;
    /**
     * The errorCategory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $errorCategory;
    /**
     * Constructor method for BaseResponse
     * @uses BaseResponse::setStatus()
     * @uses BaseResponse::setErrorCode()
     * @uses BaseResponse::setErrorMessage()
     * @uses BaseResponse::setErrorCategory()
     * @param string $status
     * @param string $errorCode
     * @param string $errorMessage
     * @param string $errorCategory
     */
    public function __construct($status = null, $errorCode = null, $errorMessage = null, $errorCategory = null)
    {
        $this
            ->setStatus($status)
            ->setErrorCode($errorCode)
            ->setErrorMessage($errorMessage)
            ->setErrorCategory($errorCategory);
    }
    /**
     * Get status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->status) ? $this->status : null;
    }
    /**
     * Set status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $status
     * @return \StructType\BaseResponse
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->status);
        } else {
            $this->status = $status;
        }
        return $this;
    }
    /**
     * Get errorCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErrorCode()
    {
        return isset($this->errorCode) ? $this->errorCode : null;
    }
    /**
     * Set errorCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $errorCode
     * @return \StructType\BaseResponse
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: string
        if (!is_null($errorCode) && !is_string($errorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorCode, true), gettype($errorCode)), __LINE__);
        }
        if (is_null($errorCode) || (is_array($errorCode) && empty($errorCode))) {
            unset($this->errorCode);
        } else {
            $this->errorCode = $errorCode;
        }
        return $this;
    }
    /**
     * Get errorMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErrorMessage()
    {
        return isset($this->errorMessage) ? $this->errorMessage : null;
    }
    /**
     * Set errorMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $errorMessage
     * @return \StructType\BaseResponse
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        if (is_null($errorMessage) || (is_array($errorMessage) && empty($errorMessage))) {
            unset($this->errorMessage);
        } else {
            $this->errorMessage = $errorMessage;
        }
        return $this;
    }
    /**
     * Get errorCategory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErrorCategory()
    {
        return isset($this->errorCategory) ? $this->errorCategory : null;
    }
    /**
     * Set errorCategory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $errorCategory
     * @return \StructType\BaseResponse
     */
    public function setErrorCategory($errorCategory = null)
    {
        // validation for constraint: string
        if (!is_null($errorCategory) && !is_string($errorCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorCategory, true), gettype($errorCategory)), __LINE__);
        }
        if (is_null($errorCategory) || (is_array($errorCategory) && empty($errorCategory))) {
            unset($this->errorCategory);
        } else {
            $this->errorCategory = $errorCategory;
        }
        return $this;
    }
}
