<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddressModel StructType
 * @subpackage Structs
 */
class AddressModel extends AbstractStructBase
{
    /**
     * The address
     * @var string
     */
    public $address;
    /**
     * The fullName
     * @var string
     */
    public $fullName;
    /**
     * The city
     * @var string
     */
    public $city;
    /**
     * The district
     * @var string
     */
    public $district;
    /**
     * The neighborhood
     * @var string
     */
    public $neighborhood;
    /**
     * The postalCode
     * @var string
     */
    public $postalCode;
    /**
     * The gsm
     * @var string
     */
    public $gsm;
    /**
     * The tcId
     * @var string
     */
    public $tcId;
    /**
     * The taxId
     * @var string
     */
    public $taxId;
    /**
     * The taxHouse
     * @var string
     */
    public $taxHouse;
    /**
     * Constructor method for AddressModel
     * @uses AddressModel::setAddress()
     * @uses AddressModel::setFullName()
     * @uses AddressModel::setCity()
     * @uses AddressModel::setDistrict()
     * @uses AddressModel::setNeighborhood()
     * @uses AddressModel::setPostalCode()
     * @uses AddressModel::setGsm()
     * @uses AddressModel::setTcId()
     * @uses AddressModel::setTaxId()
     * @uses AddressModel::setTaxHouse()
     * @param string $address
     * @param string $fullName
     * @param string $city
     * @param string $district
     * @param string $neighborhood
     * @param string $postalCode
     * @param string $gsm
     * @param string $tcId
     * @param string $taxId
     * @param string $taxHouse
     */
    public function __construct($address = null, $fullName = null, $city = null, $district = null, $neighborhood = null, $postalCode = null, $gsm = null, $tcId = null, $taxId = null, $taxHouse = null)
    {
        $this
            ->setAddress($address)
            ->setFullName($fullName)
            ->setCity($city)
            ->setDistrict($district)
            ->setNeighborhood($neighborhood)
            ->setPostalCode($postalCode)
            ->setGsm($gsm)
            ->setTcId($tcId)
            ->setTaxId($taxId)
            ->setTaxHouse($taxHouse);
    }
    /**
     * Get address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->address;
    }
    /**
     * Set address value
     * @param string $address
     * @return \StructType\AddressModel
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address, true), gettype($address)), __LINE__);
        }
        $this->address = $address;
        return $this;
    }
    /**
     * Get fullName value
     * @return string|null
     */
    public function getFullName()
    {
        return $this->fullName;
    }
    /**
     * Set fullName value
     * @param string $fullName
     * @return \StructType\AddressModel
     */
    public function setFullName($fullName = null)
    {
        // validation for constraint: string
        if (!is_null($fullName) && !is_string($fullName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fullName, true), gettype($fullName)), __LINE__);
        }
        $this->fullName = $fullName;
        return $this;
    }
    /**
     * Get city value
     * @return string|null
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * Set city value
     * @param string $city
     * @return \StructType\AddressModel
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        $this->city = $city;
        return $this;
    }
    /**
     * Get district value
     * @return string|null
     */
    public function getDistrict()
    {
        return $this->district;
    }
    /**
     * Set district value
     * @param string $district
     * @return \StructType\AddressModel
     */
    public function setDistrict($district = null)
    {
        // validation for constraint: string
        if (!is_null($district) && !is_string($district)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($district, true), gettype($district)), __LINE__);
        }
        $this->district = $district;
        return $this;
    }
    /**
     * Get neighborhood value
     * @return string|null
     */
    public function getNeighborhood()
    {
        return $this->neighborhood;
    }
    /**
     * Set neighborhood value
     * @param string $neighborhood
     * @return \StructType\AddressModel
     */
    public function setNeighborhood($neighborhood = null)
    {
        // validation for constraint: string
        if (!is_null($neighborhood) && !is_string($neighborhood)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($neighborhood, true), gettype($neighborhood)), __LINE__);
        }
        $this->neighborhood = $neighborhood;
        return $this;
    }
    /**
     * Get postalCode value
     * @return string|null
     */
    public function getPostalCode()
    {
        return $this->postalCode;
    }
    /**
     * Set postalCode value
     * @param string $postalCode
     * @return \StructType\AddressModel
     */
    public function setPostalCode($postalCode = null)
    {
        // validation for constraint: string
        if (!is_null($postalCode) && !is_string($postalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postalCode, true), gettype($postalCode)), __LINE__);
        }
        $this->postalCode = $postalCode;
        return $this;
    }
    /**
     * Get gsm value
     * @return string|null
     */
    public function getGsm()
    {
        return $this->gsm;
    }
    /**
     * Set gsm value
     * @param string $gsm
     * @return \StructType\AddressModel
     */
    public function setGsm($gsm = null)
    {
        // validation for constraint: string
        if (!is_null($gsm) && !is_string($gsm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gsm, true), gettype($gsm)), __LINE__);
        }
        $this->gsm = $gsm;
        return $this;
    }
    /**
     * Get tcId value
     * @return string|null
     */
    public function getTcId()
    {
        return $this->tcId;
    }
    /**
     * Set tcId value
     * @param string $tcId
     * @return \StructType\AddressModel
     */
    public function setTcId($tcId = null)
    {
        // validation for constraint: string
        if (!is_null($tcId) && !is_string($tcId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tcId, true), gettype($tcId)), __LINE__);
        }
        $this->tcId = $tcId;
        return $this;
    }
    /**
     * Get taxId value
     * @return string|null
     */
    public function getTaxId()
    {
        return $this->taxId;
    }
    /**
     * Set taxId value
     * @param string $taxId
     * @return \StructType\AddressModel
     */
    public function setTaxId($taxId = null)
    {
        // validation for constraint: string
        if (!is_null($taxId) && !is_string($taxId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxId, true), gettype($taxId)), __LINE__);
        }
        $this->taxId = $taxId;
        return $this;
    }
    /**
     * Get taxHouse value
     * @return string|null
     */
    public function getTaxHouse()
    {
        return $this->taxHouse;
    }
    /**
     * Set taxHouse value
     * @param string $taxHouse
     * @return \StructType\AddressModel
     */
    public function setTaxHouse($taxHouse = null)
    {
        // validation for constraint: string
        if (!is_null($taxHouse) && !is_string($taxHouse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxHouse, true), gettype($taxHouse)), __LINE__);
        }
        $this->taxHouse = $taxHouse;
        return $this;
    }
}
