<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MakeOrderItemShipmentRequest StructType
 * @subpackage Structs
 */
class MakeOrderItemShipmentRequest extends AbstractStructBase
{
    /**
     * The auth
     * @var \StructType\Authentication
     */
    public $auth;
    /**
     * The orderItemList
     * @var \StructType\OrderItemListShipmentRequest
     */
    public $orderItemList;
    /**
     * Constructor method for MakeOrderItemShipmentRequest
     * @uses MakeOrderItemShipmentRequest::setAuth()
     * @uses MakeOrderItemShipmentRequest::setOrderItemList()
     * @param \StructType\Authentication $auth
     * @param \StructType\OrderItemListShipmentRequest $orderItemList
     */
    public function __construct(\StructType\Authentication $auth = null, \StructType\OrderItemListShipmentRequest $orderItemList = null)
    {
        $this
            ->setAuth($auth)
            ->setOrderItemList($orderItemList);
    }
    /**
     * Get auth value
     * @return \StructType\Authentication|null
     */
    public function getAuth()
    {
        return $this->auth;
    }
    /**
     * Set auth value
     * @param \StructType\Authentication $auth
     * @return \StructType\MakeOrderItemShipmentRequest
     */
    public function setAuth(\StructType\Authentication $auth = null)
    {
        $this->auth = $auth;
        return $this;
    }
    /**
     * Get orderItemList value
     * @return \StructType\OrderItemListShipmentRequest|null
     */
    public function getOrderItemList()
    {
        return $this->orderItemList;
    }
    /**
     * Set orderItemList value
     * @param \StructType\OrderItemListShipmentRequest $orderItemList
     * @return \StructType\MakeOrderItemShipmentRequest
     */
    public function setOrderItemList(\StructType\OrderItemListShipmentRequest $orderItemList = null)
    {
        $this->orderItemList = $orderItemList;
        return $this;
    }
}
