<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Authentication StructType
 * @subpackage Structs
 */
class Authentication extends AbstractStructBase
{
    /**
     * The appKey
     * @var string
     */
    public $appKey;
    /**
     * The appSecret
     * @var mixed
     */
    public $appSecret;
    /**
     * Constructor method for Authentication
     * @uses Authentication::setAppKey()
     * @uses Authentication::setAppSecret()
     * @param string $appKey
     * @param mixed $appSecret
     */
    public function __construct($appKey = null, $appSecret = null)
    {
        $this
            ->setAppKey($appKey)
            ->setAppSecret($appSecret);
    }
    /**
     * Get appKey value
     * @return string|null
     */
    public function getAppKey()
    {
        return $this->appKey;
    }
    /**
     * Set appKey value
     * @param string $appKey
     * @return \StructType\Authentication
     */
    public function setAppKey($appKey = null)
    {
        // validation for constraint: string
        if (!is_null($appKey) && !is_string($appKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($appKey, true), gettype($appKey)), __LINE__);
        }
        $this->appKey = $appKey;
        return $this;
    }
    /**
     * Get appSecret value
     * @return mixed|null
     */
    public function getAppSecret()
    {
        return $this->appSecret;
    }
    /**
     * Set appSecret value
     * @param mixed $appSecret
     * @return \StructType\Authentication
     */
    public function setAppSecret($appSecret = null)
    {
        $this->appSecret = $appSecret;
        return $this;
    }
}
