<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemWithComplementaryList StructType
 * @subpackage Structs
 */
class ItemWithComplementaryList extends AbstractStructBase
{
    /**
     * The itemWithComplementary
     * Meta informations extracted from the WSDL
     * - maxOccurs: 500
     * @var \StructType\ItemWithComplementaryData[]
     */
    public $itemWithComplementary;
    /**
     * Constructor method for ItemWithComplementaryList
     * @uses ItemWithComplementaryList::setItemWithComplementary()
     * @param \StructType\ItemWithComplementaryData[] $itemWithComplementary
     */
    public function __construct(array $itemWithComplementary = array())
    {
        $this
            ->setItemWithComplementary($itemWithComplementary);
    }
    /**
     * Get itemWithComplementary value
     * @return \StructType\ItemWithComplementaryData[]|null
     */
    public function getItemWithComplementary()
    {
        return $this->itemWithComplementary;
    }
    /**
     * Set itemWithComplementary value
     * @throws \InvalidArgumentException
     * @param \StructType\ItemWithComplementaryData[] $itemWithComplementary
     * @return \StructType\ItemWithComplementaryList
     */
    public function setItemWithComplementary(array $itemWithComplementary = array())
    {
        foreach ($itemWithComplementary as $itemWithComplementaryListItemWithComplementaryItem) {
            // validation for constraint: itemType
            if (!$itemWithComplementaryListItemWithComplementaryItem instanceof \StructType\ItemWithComplementaryData) {
                throw new \InvalidArgumentException(sprintf('The itemWithComplementary property can only contain items of \StructType\ItemWithComplementaryData, "%s" given', is_object($itemWithComplementaryListItemWithComplementaryItem) ? get_class($itemWithComplementaryListItemWithComplementaryItem) : gettype($itemWithComplementaryListItemWithComplementaryItem)), __LINE__);
            }
        }
        $this->itemWithComplementary = $itemWithComplementary;
        return $this;
    }
    /**
     * Add item to itemWithComplementary value
     * @throws \InvalidArgumentException
     * @param \StructType\ItemWithComplementaryData $item
     * @return \StructType\ItemWithComplementaryList
     */
    public function addToItemWithComplementary(\StructType\ItemWithComplementaryData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ItemWithComplementaryData) {
            throw new \InvalidArgumentException(sprintf('The itemWithComplementary property can only contain items of \StructType\ItemWithComplementaryData, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->itemWithComplementary[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ItemWithComplementaryList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
