<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BillingTemplate StructType
 * @subpackage Structs
 */
class BillingTemplate extends AbstractStructBase
{
    /**
     * The originalPrice
     * @var float
     */
    public $originalPrice;
    /**
     * The totalSellerDiscount
     * @var float
     */
    public $totalSellerDiscount;
    /**
     * The totalServiceItemOriginalPrice
     * @var float
     */
    public $totalServiceItemOriginalPrice;
    /**
     * The installmentChargeWithVat
     * @var float
     */
    public $installmentChargeWithVat;
    /**
     * The sellerInvoiceAmount
     * @var float
     */
    public $sellerInvoiceAmount;
    /**
     * The totalMallDiscountPrice
     * @var float
     */
    public $totalMallDiscountPrice;
    /**
     * The dueAmount
     * @var float
     */
    public $dueAmount;
    /**
     * Constructor method for BillingTemplate
     * @uses BillingTemplate::setOriginalPrice()
     * @uses BillingTemplate::setTotalSellerDiscount()
     * @uses BillingTemplate::setTotalServiceItemOriginalPrice()
     * @uses BillingTemplate::setInstallmentChargeWithVat()
     * @uses BillingTemplate::setSellerInvoiceAmount()
     * @uses BillingTemplate::setTotalMallDiscountPrice()
     * @uses BillingTemplate::setDueAmount()
     * @param float $originalPrice
     * @param float $totalSellerDiscount
     * @param float $totalServiceItemOriginalPrice
     * @param float $installmentChargeWithVat
     * @param float $sellerInvoiceAmount
     * @param float $totalMallDiscountPrice
     * @param float $dueAmount
     */
    public function __construct($originalPrice = null, $totalSellerDiscount = null, $totalServiceItemOriginalPrice = null, $installmentChargeWithVat = null, $sellerInvoiceAmount = null, $totalMallDiscountPrice = null, $dueAmount = null)
    {
        $this
            ->setOriginalPrice($originalPrice)
            ->setTotalSellerDiscount($totalSellerDiscount)
            ->setTotalServiceItemOriginalPrice($totalServiceItemOriginalPrice)
            ->setInstallmentChargeWithVat($installmentChargeWithVat)
            ->setSellerInvoiceAmount($sellerInvoiceAmount)
            ->setTotalMallDiscountPrice($totalMallDiscountPrice)
            ->setDueAmount($dueAmount);
    }
    /**
     * Get originalPrice value
     * @return float|null
     */
    public function getOriginalPrice()
    {
        return $this->originalPrice;
    }
    /**
     * Set originalPrice value
     * @param float $originalPrice
     * @return \StructType\BillingTemplate
     */
    public function setOriginalPrice($originalPrice = null)
    {
        $this->originalPrice = $originalPrice;
        return $this;
    }
    /**
     * Get totalSellerDiscount value
     * @return float|null
     */
    public function getTotalSellerDiscount()
    {
        return $this->totalSellerDiscount;
    }
    /**
     * Set totalSellerDiscount value
     * @param float $totalSellerDiscount
     * @return \StructType\BillingTemplate
     */
    public function setTotalSellerDiscount($totalSellerDiscount = null)
    {
        $this->totalSellerDiscount = $totalSellerDiscount;
        return $this;
    }
    /**
     * Get totalServiceItemOriginalPrice value
     * @return float|null
     */
    public function getTotalServiceItemOriginalPrice()
    {
        return $this->totalServiceItemOriginalPrice;
    }
    /**
     * Set totalServiceItemOriginalPrice value
     * @param float $totalServiceItemOriginalPrice
     * @return \StructType\BillingTemplate
     */
    public function setTotalServiceItemOriginalPrice($totalServiceItemOriginalPrice = null)
    {
        $this->totalServiceItemOriginalPrice = $totalServiceItemOriginalPrice;
        return $this;
    }
    /**
     * Get installmentChargeWithVat value
     * @return float|null
     */
    public function getInstallmentChargeWithVat()
    {
        return $this->installmentChargeWithVat;
    }
    /**
     * Set installmentChargeWithVat value
     * @param float $installmentChargeWithVat
     * @return \StructType\BillingTemplate
     */
    public function setInstallmentChargeWithVat($installmentChargeWithVat = null)
    {
        $this->installmentChargeWithVat = $installmentChargeWithVat;
        return $this;
    }
    /**
     * Get sellerInvoiceAmount value
     * @return float|null
     */
    public function getSellerInvoiceAmount()
    {
        return $this->sellerInvoiceAmount;
    }
    /**
     * Set sellerInvoiceAmount value
     * @param float $sellerInvoiceAmount
     * @return \StructType\BillingTemplate
     */
    public function setSellerInvoiceAmount($sellerInvoiceAmount = null)
    {
        $this->sellerInvoiceAmount = $sellerInvoiceAmount;
        return $this;
    }
    /**
     * Get totalMallDiscountPrice value
     * @return float|null
     */
    public function getTotalMallDiscountPrice()
    {
        return $this->totalMallDiscountPrice;
    }
    /**
     * Set totalMallDiscountPrice value
     * @param float $totalMallDiscountPrice
     * @return \StructType\BillingTemplate
     */
    public function setTotalMallDiscountPrice($totalMallDiscountPrice = null)
    {
        $this->totalMallDiscountPrice = $totalMallDiscountPrice;
        return $this;
    }
    /**
     * Get dueAmount value
     * @return float|null
     */
    public function getDueAmount()
    {
        return $this->dueAmount;
    }
    /**
     * Set dueAmount value
     * @param float $dueAmount
     * @return \StructType\BillingTemplate
     */
    public function setDueAmount($dueAmount = null)
    {
        $this->dueAmount = $dueAmount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BillingTemplate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
