<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DetailedOrderListResponse StructType
 * @subpackage Structs
 */
class DetailedOrderListResponse extends AbstractStructBase
{
    /**
     * The result
     * @var \StructType\ResultInfo
     */
    public $result;
    /**
     * The orderList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DetailedOrderDataList
     */
    public $orderList;
    /**
     * The pagingData
     * @var \StructType\PagingData
     */
    public $pagingData;
    /**
     * Constructor method for DetailedOrderListResponse
     * @uses DetailedOrderListResponse::setResult()
     * @uses DetailedOrderListResponse::setOrderList()
     * @uses DetailedOrderListResponse::setPagingData()
     * @param \StructType\ResultInfo $result
     * @param \StructType\DetailedOrderDataList $orderList
     * @param \StructType\PagingData $pagingData
     */
    public function __construct(\StructType\ResultInfo $result = null, \StructType\DetailedOrderDataList $orderList = null, \StructType\PagingData $pagingData = null)
    {
        $this
            ->setResult($result)
            ->setOrderList($orderList)
            ->setPagingData($pagingData);
    }
    /**
     * Get result value
     * @return \StructType\ResultInfo|null
     */
    public function getResult()
    {
        return $this->result;
    }
    /**
     * Set result value
     * @param \StructType\ResultInfo $result
     * @return \StructType\DetailedOrderListResponse
     */
    public function setResult(\StructType\ResultInfo $result = null)
    {
        $this->result = $result;
        return $this;
    }
    /**
     * Get orderList value
     * @return \StructType\DetailedOrderDataList|null
     */
    public function getOrderList()
    {
        return $this->orderList;
    }
    /**
     * Set orderList value
     * @param \StructType\DetailedOrderDataList $orderList
     * @return \StructType\DetailedOrderListResponse
     */
    public function setOrderList(\StructType\DetailedOrderDataList $orderList = null)
    {
        $this->orderList = $orderList;
        return $this;
    }
    /**
     * Get pagingData value
     * @return \StructType\PagingData|null
     */
    public function getPagingData()
    {
        return $this->pagingData;
    }
    /**
     * Set pagingData value
     * @param \StructType\PagingData $pagingData
     * @return \StructType\DetailedOrderListResponse
     */
    public function setPagingData(\StructType\PagingData $pagingData = null)
    {
        $this->pagingData = $pagingData;
        return $this;
    }
}
