<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderItemShipment StructType
 * @subpackage Structs
 */
class OrderItemShipment extends AbstractStructBase
{
    /**
     * The id
     * @var int
     */
    public $id;
    /**
     * The price
     * @var float
     */
    public $price;
    /**
     * The sellerDiscount
     * @var float
     */
    public $sellerDiscount;
    /**
     * The mallDiscount
     * @var float
     */
    public $mallDiscount;
    /**
     * The commission
     * @var float
     */
    public $commission;
    /**
     * The status
     * @var int
     */
    public $status;
    /**
     * The quantity
     * @var int
     */
    public $quantity;
    /**
     * The productName
     * @var string
     */
    public $productName;
    /**
     * The shipmentInfo
     * @var \StructType\OrderItemShipmentInfo
     */
    public $shipmentInfo;
    /**
     * Constructor method for OrderItemShipment
     * @uses OrderItemShipment::setId()
     * @uses OrderItemShipment::setPrice()
     * @uses OrderItemShipment::setSellerDiscount()
     * @uses OrderItemShipment::setMallDiscount()
     * @uses OrderItemShipment::setCommission()
     * @uses OrderItemShipment::setStatus()
     * @uses OrderItemShipment::setQuantity()
     * @uses OrderItemShipment::setProductName()
     * @uses OrderItemShipment::setShipmentInfo()
     * @param int $id
     * @param float $price
     * @param float $sellerDiscount
     * @param float $mallDiscount
     * @param float $commission
     * @param int $status
     * @param int $quantity
     * @param string $productName
     * @param \StructType\OrderItemShipmentInfo $shipmentInfo
     */
    public function __construct($id = null, $price = null, $sellerDiscount = null, $mallDiscount = null, $commission = null, $status = null, $quantity = null, $productName = null, \StructType\OrderItemShipmentInfo $shipmentInfo = null)
    {
        $this
            ->setId($id)
            ->setPrice($price)
            ->setSellerDiscount($sellerDiscount)
            ->setMallDiscount($mallDiscount)
            ->setCommission($commission)
            ->setStatus($status)
            ->setQuantity($quantity)
            ->setProductName($productName)
            ->setShipmentInfo($shipmentInfo);
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\OrderItemShipment
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get price value
     * @return float|null
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * Set price value
     * @param float $price
     * @return \StructType\OrderItemShipment
     */
    public function setPrice($price = null)
    {
        // validation for constraint: float
        if (!is_null($price) && !(is_float($price) || is_numeric($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        $this->price = $price;
        return $this;
    }
    /**
     * Get sellerDiscount value
     * @return float|null
     */
    public function getSellerDiscount()
    {
        return $this->sellerDiscount;
    }
    /**
     * Set sellerDiscount value
     * @param float $sellerDiscount
     * @return \StructType\OrderItemShipment
     */
    public function setSellerDiscount($sellerDiscount = null)
    {
        // validation for constraint: float
        if (!is_null($sellerDiscount) && !(is_float($sellerDiscount) || is_numeric($sellerDiscount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($sellerDiscount, true), gettype($sellerDiscount)), __LINE__);
        }
        $this->sellerDiscount = $sellerDiscount;
        return $this;
    }
    /**
     * Get mallDiscount value
     * @return float|null
     */
    public function getMallDiscount()
    {
        return $this->mallDiscount;
    }
    /**
     * Set mallDiscount value
     * @param float $mallDiscount
     * @return \StructType\OrderItemShipment
     */
    public function setMallDiscount($mallDiscount = null)
    {
        // validation for constraint: float
        if (!is_null($mallDiscount) && !(is_float($mallDiscount) || is_numeric($mallDiscount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($mallDiscount, true), gettype($mallDiscount)), __LINE__);
        }
        $this->mallDiscount = $mallDiscount;
        return $this;
    }
    /**
     * Get commission value
     * @return float|null
     */
    public function getCommission()
    {
        return $this->commission;
    }
    /**
     * Set commission value
     * @param float $commission
     * @return \StructType\OrderItemShipment
     */
    public function setCommission($commission = null)
    {
        // validation for constraint: float
        if (!is_null($commission) && !(is_float($commission) || is_numeric($commission))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($commission, true), gettype($commission)), __LINE__);
        }
        $this->commission = $commission;
        return $this;
    }
    /**
     * Get status value
     * @return int|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param int $status
     * @return \StructType\OrderItemShipment
     */
    public function setStatus($status = null)
    {
        // validation for constraint: int
        if (!is_null($status) && !(is_int($status) || ctype_digit($status))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param int $quantity
     * @return \StructType\OrderItemShipment
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get productName value
     * @return string|null
     */
    public function getProductName()
    {
        return $this->productName;
    }
    /**
     * Set productName value
     * @param string $productName
     * @return \StructType\OrderItemShipment
     */
    public function setProductName($productName = null)
    {
        // validation for constraint: string
        if (!is_null($productName) && !is_string($productName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productName, true), gettype($productName)), __LINE__);
        }
        $this->productName = $productName;
        return $this;
    }
    /**
     * Get shipmentInfo value
     * @return \StructType\OrderItemShipmentInfo|null
     */
    public function getShipmentInfo()
    {
        return $this->shipmentInfo;
    }
    /**
     * Set shipmentInfo value
     * @param \StructType\OrderItemShipmentInfo $shipmentInfo
     * @return \StructType\OrderItemShipment
     */
    public function setShipmentInfo(\StructType\OrderItemShipmentInfo $shipmentInfo = null)
    {
        $this->shipmentInfo = $shipmentInfo;
        return $this;
    }
}
