<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://api.n11.com/ws/OrderService.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://api.n11.com/ws/OrderService.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Order ServiceType
 */
$order = new \ServiceType\Order($options);
/**
 * Sample call for OrderList operation/method
 */
if ($order->OrderList(new \StructType\OrderListRequest()) !== false) {
    print_r($order->getResult());
} else {
    print_r($order->getLastError());
}
/**
 * Sample call for OrderItemAccept operation/method
 */
if ($order->OrderItemAccept(new \StructType\OrderItemAcceptRequest()) !== false) {
    print_r($order->getResult());
} else {
    print_r($order->getLastError());
}
/**
 * Sample call for OrderItemReject operation/method
 */
if ($order->OrderItemReject(new \StructType\OrderItemRejectRequest()) !== false) {
    print_r($order->getResult());
} else {
    print_r($order->getLastError());
}
/**
 * Sample call for OrderDetail operation/method
 */
if ($order->OrderDetail(new \StructType\OrderDetailRequest()) !== false) {
    print_r($order->getResult());
} else {
    print_r($order->getLastError());
}
/**
 * Samples for Detailed ServiceType
 */
$detailed = new \ServiceType\Detailed($options);
/**
 * Sample call for DetailedOrderList operation/method
 */
if ($detailed->DetailedOrderList(new \StructType\DetailedOrderListRequest()) !== false) {
    print_r($detailed->getResult());
} else {
    print_r($detailed->getLastError());
}
/**
 * Samples for Make ServiceType
 */
$make = new \ServiceType\Make($options);
/**
 * Sample call for MakeOrderItemShipment operation/method
 */
if ($make->MakeOrderItemShipment(new \StructType\MakeOrderItemShipmentRequest()) !== false) {
    print_r($make->getResult());
} else {
    print_r($make->getLastError());
}
/**
 * Samples for Complementary ServiceType
 */
$complementary = new \ServiceType\Complementary($options);
/**
 * Sample call for ComplementaryItemDetail operation/method
 */
if ($complementary->ComplementaryItemDetail(new \StructType\ComplementaryItemDetailRequest()) !== false) {
    print_r($complementary->getResult());
} else {
    print_r($complementary->getLastError());
}
/**
 * Samples for Combine ServiceType
 */
$combine = new \ServiceType\Combine($options);
/**
 * Sample call for CombineItems operation/method
 */
if ($combine->CombineItems(new \StructType\CombineItemsRequest()) !== false) {
    print_r($combine->getResult());
} else {
    print_r($combine->getLastError());
}
/**
 * Samples for Separate ServiceType
 */
$separate = new \ServiceType\Separate($options);
/**
 * Sample call for SeparateCombinedItems operation/method
 */
if ($separate->SeparateCombinedItems(new \StructType\SeparateCombinedItemsRequest()) !== false) {
    print_r($separate->getResult());
} else {
    print_r($separate->getLastError());
}
