<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderItemData StructType
 * @subpackage Structs
 */
class OrderItemData extends AbstractStructBase
{
    /**
     * The id
     * @var int
     */
    public $id;
    /**
     * The productSellerCode
     * @var string
     */
    public $productSellerCode;
    /**
     * The price
     * @var float
     */
    public $price;
    /**
     * The sellerDiscount
     * @var float
     */
    public $sellerDiscount;
    /**
     * The mallDiscount
     * @var float
     */
    public $mallDiscount;
    /**
     * The commission
     * @var float
     */
    public $commission;
    /**
     * The status
     * @var int
     */
    public $status;
    /**
     * The quantity
     * @var int
     */
    public $quantity;
    /**
     * The productName
     * @var string
     */
    public $productName;
    /**
     * The deliveryFeeType
     * @var int
     */
    public $deliveryFeeType;
    /**
     * The dueAmount
     * @var float
     */
    public $dueAmount;
    /**
     * The shipmentInfo
     * @var \StructType\OrderItemShipmentInfo
     */
    public $shipmentInfo;
    /**
     * The attributes
     * @var \StructType\SkuAttributeList
     */
    public $attributes;
    /**
     * The customTextOptionValues
     * @var \StructType\CustomTextOptionsDataList
     */
    public $customTextOptionValues;
    /**
     * Constructor method for OrderItemData
     * @uses OrderItemData::setId()
     * @uses OrderItemData::setProductSellerCode()
     * @uses OrderItemData::setPrice()
     * @uses OrderItemData::setSellerDiscount()
     * @uses OrderItemData::setMallDiscount()
     * @uses OrderItemData::setCommission()
     * @uses OrderItemData::setStatus()
     * @uses OrderItemData::setQuantity()
     * @uses OrderItemData::setProductName()
     * @uses OrderItemData::setDeliveryFeeType()
     * @uses OrderItemData::setDueAmount()
     * @uses OrderItemData::setShipmentInfo()
     * @uses OrderItemData::setAttributes()
     * @uses OrderItemData::setCustomTextOptionValues()
     * @param int $id
     * @param string $productSellerCode
     * @param float $price
     * @param float $sellerDiscount
     * @param float $mallDiscount
     * @param float $commission
     * @param int $status
     * @param int $quantity
     * @param string $productName
     * @param int $deliveryFeeType
     * @param float $dueAmount
     * @param \StructType\OrderItemShipmentInfo $shipmentInfo
     * @param \StructType\SkuAttributeList $attributes
     * @param \StructType\CustomTextOptionsDataList $customTextOptionValues
     */
    public function __construct($id = null, $productSellerCode = null, $price = null, $sellerDiscount = null, $mallDiscount = null, $commission = null, $status = null, $quantity = null, $productName = null, $deliveryFeeType = null, $dueAmount = null, \StructType\OrderItemShipmentInfo $shipmentInfo = null, \StructType\SkuAttributeList $attributes = null, \StructType\CustomTextOptionsDataList $customTextOptionValues = null)
    {
        $this
            ->setId($id)
            ->setProductSellerCode($productSellerCode)
            ->setPrice($price)
            ->setSellerDiscount($sellerDiscount)
            ->setMallDiscount($mallDiscount)
            ->setCommission($commission)
            ->setStatus($status)
            ->setQuantity($quantity)
            ->setProductName($productName)
            ->setDeliveryFeeType($deliveryFeeType)
            ->setDueAmount($dueAmount)
            ->setShipmentInfo($shipmentInfo)
            ->setAttributes($attributes)
            ->setCustomTextOptionValues($customTextOptionValues);
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\OrderItemData
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !is_numeric($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get productSellerCode value
     * @return string|null
     */
    public function getProductSellerCode()
    {
        return $this->productSellerCode;
    }
    /**
     * Set productSellerCode value
     * @param string $productSellerCode
     * @return \StructType\OrderItemData
     */
    public function setProductSellerCode($productSellerCode = null)
    {
        // validation for constraint: string
        if (!is_null($productSellerCode) && !is_string($productSellerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productSellerCode)), __LINE__);
        }
        $this->productSellerCode = $productSellerCode;
        return $this;
    }
    /**
     * Get price value
     * @return float|null
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * Set price value
     * @param float $price
     * @return \StructType\OrderItemData
     */
    public function setPrice($price = null)
    {
        $this->price = $price;
        return $this;
    }
    /**
     * Get sellerDiscount value
     * @return float|null
     */
    public function getSellerDiscount()
    {
        return $this->sellerDiscount;
    }
    /**
     * Set sellerDiscount value
     * @param float $sellerDiscount
     * @return \StructType\OrderItemData
     */
    public function setSellerDiscount($sellerDiscount = null)
    {
        $this->sellerDiscount = $sellerDiscount;
        return $this;
    }
    /**
     * Get mallDiscount value
     * @return float|null
     */
    public function getMallDiscount()
    {
        return $this->mallDiscount;
    }
    /**
     * Set mallDiscount value
     * @param float $mallDiscount
     * @return \StructType\OrderItemData
     */
    public function setMallDiscount($mallDiscount = null)
    {
        $this->mallDiscount = $mallDiscount;
        return $this;
    }
    /**
     * Get commission value
     * @return float|null
     */
    public function getCommission()
    {
        return $this->commission;
    }
    /**
     * Set commission value
     * @param float $commission
     * @return \StructType\OrderItemData
     */
    public function setCommission($commission = null)
    {
        $this->commission = $commission;
        return $this;
    }
    /**
     * Get status value
     * @return int|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param int $status
     * @return \StructType\OrderItemData
     */
    public function setStatus($status = null)
    {
        // validation for constraint: int
        if (!is_null($status) && !is_numeric($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param int $quantity
     * @return \StructType\OrderItemData
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !is_numeric($quantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($quantity)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get productName value
     * @return string|null
     */
    public function getProductName()
    {
        return $this->productName;
    }
    /**
     * Set productName value
     * @param string $productName
     * @return \StructType\OrderItemData
     */
    public function setProductName($productName = null)
    {
        // validation for constraint: string
        if (!is_null($productName) && !is_string($productName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productName)), __LINE__);
        }
        $this->productName = $productName;
        return $this;
    }
    /**
     * Get deliveryFeeType value
     * @return int|null
     */
    public function getDeliveryFeeType()
    {
        return $this->deliveryFeeType;
    }
    /**
     * Set deliveryFeeType value
     * @param int $deliveryFeeType
     * @return \StructType\OrderItemData
     */
    public function setDeliveryFeeType($deliveryFeeType = null)
    {
        // validation for constraint: int
        if (!is_null($deliveryFeeType) && !is_numeric($deliveryFeeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($deliveryFeeType)), __LINE__);
        }
        $this->deliveryFeeType = $deliveryFeeType;
        return $this;
    }
    /**
     * Get dueAmount value
     * @return float|null
     */
    public function getDueAmount()
    {
        return $this->dueAmount;
    }
    /**
     * Set dueAmount value
     * @param float $dueAmount
     * @return \StructType\OrderItemData
     */
    public function setDueAmount($dueAmount = null)
    {
        $this->dueAmount = $dueAmount;
        return $this;
    }
    /**
     * Get shipmentInfo value
     * @return \StructType\OrderItemShipmentInfo|null
     */
    public function getShipmentInfo()
    {
        return $this->shipmentInfo;
    }
    /**
     * Set shipmentInfo value
     * @param \StructType\OrderItemShipmentInfo $shipmentInfo
     * @return \StructType\OrderItemData
     */
    public function setShipmentInfo(\StructType\OrderItemShipmentInfo $shipmentInfo = null)
    {
        $this->shipmentInfo = $shipmentInfo;
        return $this;
    }
    /**
     * Get attributes value
     * @return \StructType\SkuAttributeList|null
     */
    public function getAttributes()
    {
        return $this->attributes;
    }
    /**
     * Set attributes value
     * @param \StructType\SkuAttributeList $attributes
     * @return \StructType\OrderItemData
     */
    public function setAttributes(\StructType\SkuAttributeList $attributes = null)
    {
        $this->attributes = $attributes;
        return $this;
    }
    /**
     * Get customTextOptionValues value
     * @return \StructType\CustomTextOptionsDataList|null
     */
    public function getCustomTextOptionValues()
    {
        return $this->customTextOptionValues;
    }
    /**
     * Set customTextOptionValues value
     * @param \StructType\CustomTextOptionsDataList $customTextOptionValues
     * @return \StructType\OrderItemData
     */
    public function setCustomTextOptionValues(\StructType\CustomTextOptionsDataList $customTextOptionValues = null)
    {
        $this->customTextOptionValues = $customTextOptionValues;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OrderItemData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
