<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SkuAttributeList StructType
 * @subpackage Structs
 */
class SkuAttributeList extends AbstractStructBase
{
    /**
     * The attribute
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\SkuAttribute[]
     */
    public $attribute;
    /**
     * Constructor method for SkuAttributeList
     * @uses SkuAttributeList::setAttribute()
     * @param \StructType\SkuAttribute[] $attribute
     */
    public function __construct(array $attribute = array())
    {
        $this
            ->setAttribute($attribute);
    }
    /**
     * Get attribute value
     * @return \StructType\SkuAttribute[]|null
     */
    public function getAttribute()
    {
        return $this->attribute;
    }
    /**
     * Set attribute value
     * @throws \InvalidArgumentException
     * @param \StructType\SkuAttribute[] $attribute
     * @return \StructType\SkuAttributeList
     */
    public function setAttribute(array $attribute = array())
    {
        foreach ($attribute as $skuAttributeListAttributeItem) {
            // validation for constraint: itemType
            if (!$skuAttributeListAttributeItem instanceof \StructType\SkuAttribute) {
                throw new \InvalidArgumentException(sprintf('The attribute property can only contain items of \StructType\SkuAttribute, "%s" given', is_object($skuAttributeListAttributeItem) ? get_class($skuAttributeListAttributeItem) : gettype($skuAttributeListAttributeItem)), __LINE__);
            }
        }
        $this->attribute = $attribute;
        return $this;
    }
    /**
     * Add item to attribute value
     * @throws \InvalidArgumentException
     * @param \StructType\SkuAttribute $item
     * @return \StructType\SkuAttributeList
     */
    public function addToAttribute(\StructType\SkuAttribute $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SkuAttribute) {
            throw new \InvalidArgumentException(sprintf('The attribute property can only contain items of \StructType\SkuAttribute, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->attribute[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SkuAttributeList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
