<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceOrderItemDataList StructType
 * @subpackage Structs
 */
class ServiceOrderItemDataList extends AbstractStructBase
{
    /**
     * The serviceItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\ServiceOrderItemData[]
     */
    public $serviceItem;
    /**
     * Constructor method for ServiceOrderItemDataList
     * @uses ServiceOrderItemDataList::setServiceItem()
     * @param \StructType\ServiceOrderItemData[] $serviceItem
     */
    public function __construct(array $serviceItem = array())
    {
        $this
            ->setServiceItem($serviceItem);
    }
    /**
     * Get serviceItem value
     * @return \StructType\ServiceOrderItemData[]|null
     */
    public function getServiceItem()
    {
        return $this->serviceItem;
    }
    /**
     * Set serviceItem value
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceOrderItemData[] $serviceItem
     * @return \StructType\ServiceOrderItemDataList
     */
    public function setServiceItem(array $serviceItem = array())
    {
        foreach ($serviceItem as $serviceOrderItemDataListServiceItemItem) {
            // validation for constraint: itemType
            if (!$serviceOrderItemDataListServiceItemItem instanceof \StructType\ServiceOrderItemData) {
                throw new \InvalidArgumentException(sprintf('The serviceItem property can only contain items of \StructType\ServiceOrderItemData, "%s" given', is_object($serviceOrderItemDataListServiceItemItem) ? get_class($serviceOrderItemDataListServiceItemItem) : gettype($serviceOrderItemDataListServiceItemItem)), __LINE__);
            }
        }
        $this->serviceItem = $serviceItem;
        return $this;
    }
    /**
     * Add item to serviceItem value
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceOrderItemData $item
     * @return \StructType\ServiceOrderItemDataList
     */
    public function addToServiceItem(\StructType\ServiceOrderItemData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ServiceOrderItemData) {
            throw new \InvalidArgumentException(sprintf('The serviceItem property can only contain items of \StructType\ServiceOrderItemData, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->serviceItem[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ServiceOrderItemDataList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
