<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DetailedOrderItemDataList StructType
 * @subpackage Structs
 */
class DetailedOrderItemDataList extends AbstractStructBase
{
    /**
     * The orderItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\OrderItemData[]
     */
    public $orderItem;
    /**
     * Constructor method for DetailedOrderItemDataList
     * @uses DetailedOrderItemDataList::setOrderItem()
     * @param \StructType\OrderItemData[] $orderItem
     */
    public function __construct(array $orderItem = array())
    {
        $this
            ->setOrderItem($orderItem);
    }
    /**
     * Get orderItem value
     * @return \StructType\OrderItemData[]|null
     */
    public function getOrderItem()
    {
        return $this->orderItem;
    }
    /**
     * Set orderItem value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderItemData[] $orderItem
     * @return \StructType\DetailedOrderItemDataList
     */
    public function setOrderItem(array $orderItem = array())
    {
        foreach ($orderItem as $detailedOrderItemDataListOrderItemItem) {
            // validation for constraint: itemType
            if (!$detailedOrderItemDataListOrderItemItem instanceof \StructType\OrderItemData) {
                throw new \InvalidArgumentException(sprintf('The orderItem property can only contain items of \StructType\OrderItemData, "%s" given', is_object($detailedOrderItemDataListOrderItemItem) ? get_class($detailedOrderItemDataListOrderItemItem) : gettype($detailedOrderItemDataListOrderItemItem)), __LINE__);
            }
        }
        $this->orderItem = $orderItem;
        return $this;
    }
    /**
     * Add item to orderItem value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderItemData $item
     * @return \StructType\DetailedOrderItemDataList
     */
    public function addToOrderItem(\StructType\OrderItemData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrderItemData) {
            throw new \InvalidArgumentException(sprintf('The orderItem property can only contain items of \StructType\OrderItemData, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->orderItem[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DetailedOrderItemDataList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
