<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MakeOrderItemShipmentInfo StructType
 * @subpackage Structs
 */
class MakeOrderItemShipmentInfo extends AbstractStructBase
{
    /**
     * The shipmentCompany
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\ShipmentCompanyData
     */
    public $shipmentCompany;
    /**
     * The trackingNumber
     * @var string
     */
    public $trackingNumber;
    /**
     * The trackingNumberStatus
     * @var string
     */
    public $trackingNumberStatus;
    /**
     * The campaignNumber
     * @var string
     */
    public $campaignNumber;
    /**
     * The shipmentMethod
     * @var string
     */
    public $shipmentMethod;
    /**
     * Constructor method for MakeOrderItemShipmentInfo
     * @uses MakeOrderItemShipmentInfo::setShipmentCompany()
     * @uses MakeOrderItemShipmentInfo::setTrackingNumber()
     * @uses MakeOrderItemShipmentInfo::setTrackingNumberStatus()
     * @uses MakeOrderItemShipmentInfo::setCampaignNumber()
     * @uses MakeOrderItemShipmentInfo::setShipmentMethod()
     * @param \StructType\ShipmentCompanyData $shipmentCompany
     * @param string $trackingNumber
     * @param string $trackingNumberStatus
     * @param string $campaignNumber
     * @param string $shipmentMethod
     */
    public function __construct(\StructType\ShipmentCompanyData $shipmentCompany = null, $trackingNumber = null, $trackingNumberStatus = null, $campaignNumber = null, $shipmentMethod = null)
    {
        $this
            ->setShipmentCompany($shipmentCompany)
            ->setTrackingNumber($trackingNumber)
            ->setTrackingNumberStatus($trackingNumberStatus)
            ->setCampaignNumber($campaignNumber)
            ->setShipmentMethod($shipmentMethod);
    }
    /**
     * Get shipmentCompany value
     * @return \StructType\ShipmentCompanyData|null
     */
    public function getShipmentCompany()
    {
        return $this->shipmentCompany;
    }
    /**
     * Set shipmentCompany value
     * @param \StructType\ShipmentCompanyData $shipmentCompany
     * @return \StructType\MakeOrderItemShipmentInfo
     */
    public function setShipmentCompany(\StructType\ShipmentCompanyData $shipmentCompany = null)
    {
        $this->shipmentCompany = $shipmentCompany;
        return $this;
    }
    /**
     * Get trackingNumber value
     * @return string|null
     */
    public function getTrackingNumber()
    {
        return $this->trackingNumber;
    }
    /**
     * Set trackingNumber value
     * @param string $trackingNumber
     * @return \StructType\MakeOrderItemShipmentInfo
     */
    public function setTrackingNumber($trackingNumber = null)
    {
        // validation for constraint: string
        if (!is_null($trackingNumber) && !is_string($trackingNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trackingNumber, true), gettype($trackingNumber)), __LINE__);
        }
        $this->trackingNumber = $trackingNumber;
        return $this;
    }
    /**
     * Get trackingNumberStatus value
     * @return string|null
     */
    public function getTrackingNumberStatus()
    {
        return $this->trackingNumberStatus;
    }
    /**
     * Set trackingNumberStatus value
     * @param string $trackingNumberStatus
     * @return \StructType\MakeOrderItemShipmentInfo
     */
    public function setTrackingNumberStatus($trackingNumberStatus = null)
    {
        // validation for constraint: string
        if (!is_null($trackingNumberStatus) && !is_string($trackingNumberStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trackingNumberStatus, true), gettype($trackingNumberStatus)), __LINE__);
        }
        $this->trackingNumberStatus = $trackingNumberStatus;
        return $this;
    }
    /**
     * Get campaignNumber value
     * @return string|null
     */
    public function getCampaignNumber()
    {
        return $this->campaignNumber;
    }
    /**
     * Set campaignNumber value
     * @param string $campaignNumber
     * @return \StructType\MakeOrderItemShipmentInfo
     */
    public function setCampaignNumber($campaignNumber = null)
    {
        // validation for constraint: string
        if (!is_null($campaignNumber) && !is_string($campaignNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($campaignNumber, true), gettype($campaignNumber)), __LINE__);
        }
        $this->campaignNumber = $campaignNumber;
        return $this;
    }
    /**
     * Get shipmentMethod value
     * @return string|null
     */
    public function getShipmentMethod()
    {
        return $this->shipmentMethod;
    }
    /**
     * Set shipmentMethod value
     * @param string $shipmentMethod
     * @return \StructType\MakeOrderItemShipmentInfo
     */
    public function setShipmentMethod($shipmentMethod = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentMethod) && !is_string($shipmentMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipmentMethod, true), gettype($shipmentMethod)), __LINE__);
        }
        $this->shipmentMethod = $shipmentMethod;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MakeOrderItemShipmentInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
