<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BuyerAddressData StructType
 * @subpackage Structs
 */
class BuyerAddressData extends AbstractStructBase
{
    /**
     * The fullName
     * @var string
     */
    public $fullName;
    /**
     * The address
     * @var string
     */
    public $address;
    /**
     * The phoneNumber
     * @var int
     */
    public $phoneNumber;
    /**
     * The tcNo
     * @var string
     */
    public $tcNo;
    /**
     * The companyName
     * @var string
     */
    public $companyName;
    /**
     * The taxNo
     * @var string
     */
    public $taxNo;
    /**
     * The taxOffice
     * @var string
     */
    public $taxOffice;
    /**
     * Constructor method for BuyerAddressData
     * @uses BuyerAddressData::setFullName()
     * @uses BuyerAddressData::setAddress()
     * @uses BuyerAddressData::setPhoneNumber()
     * @uses BuyerAddressData::setTcNo()
     * @uses BuyerAddressData::setCompanyName()
     * @uses BuyerAddressData::setTaxNo()
     * @uses BuyerAddressData::setTaxOffice()
     * @param string $fullName
     * @param string $address
     * @param int $phoneNumber
     * @param string $tcNo
     * @param string $companyName
     * @param string $taxNo
     * @param string $taxOffice
     */
    public function __construct($fullName = null, $address = null, $phoneNumber = null, $tcNo = null, $companyName = null, $taxNo = null, $taxOffice = null)
    {
        $this
            ->setFullName($fullName)
            ->setAddress($address)
            ->setPhoneNumber($phoneNumber)
            ->setTcNo($tcNo)
            ->setCompanyName($companyName)
            ->setTaxNo($taxNo)
            ->setTaxOffice($taxOffice);
    }
    /**
     * Get fullName value
     * @return string|null
     */
    public function getFullName()
    {
        return $this->fullName;
    }
    /**
     * Set fullName value
     * @param string $fullName
     * @return \StructType\BuyerAddressData
     */
    public function setFullName($fullName = null)
    {
        // validation for constraint: string
        if (!is_null($fullName) && !is_string($fullName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fullName, true), gettype($fullName)), __LINE__);
        }
        $this->fullName = $fullName;
        return $this;
    }
    /**
     * Get address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->address;
    }
    /**
     * Set address value
     * @param string $address
     * @return \StructType\BuyerAddressData
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address, true), gettype($address)), __LINE__);
        }
        $this->address = $address;
        return $this;
    }
    /**
     * Get phoneNumber value
     * @return int|null
     */
    public function getPhoneNumber()
    {
        return $this->phoneNumber;
    }
    /**
     * Set phoneNumber value
     * @param int $phoneNumber
     * @return \StructType\BuyerAddressData
     */
    public function setPhoneNumber($phoneNumber = null)
    {
        // validation for constraint: int
        if (!is_null($phoneNumber) && !(is_int($phoneNumber) || ctype_digit($phoneNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($phoneNumber, true), gettype($phoneNumber)), __LINE__);
        }
        $this->phoneNumber = $phoneNumber;
        return $this;
    }
    /**
     * Get tcNo value
     * @return string|null
     */
    public function getTcNo()
    {
        return $this->tcNo;
    }
    /**
     * Set tcNo value
     * @param string $tcNo
     * @return \StructType\BuyerAddressData
     */
    public function setTcNo($tcNo = null)
    {
        // validation for constraint: string
        if (!is_null($tcNo) && !is_string($tcNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tcNo, true), gettype($tcNo)), __LINE__);
        }
        $this->tcNo = $tcNo;
        return $this;
    }
    /**
     * Get companyName value
     * @return string|null
     */
    public function getCompanyName()
    {
        return $this->companyName;
    }
    /**
     * Set companyName value
     * @param string $companyName
     * @return \StructType\BuyerAddressData
     */
    public function setCompanyName($companyName = null)
    {
        // validation for constraint: string
        if (!is_null($companyName) && !is_string($companyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companyName, true), gettype($companyName)), __LINE__);
        }
        $this->companyName = $companyName;
        return $this;
    }
    /**
     * Get taxNo value
     * @return string|null
     */
    public function getTaxNo()
    {
        return $this->taxNo;
    }
    /**
     * Set taxNo value
     * @param string $taxNo
     * @return \StructType\BuyerAddressData
     */
    public function setTaxNo($taxNo = null)
    {
        // validation for constraint: string
        if (!is_null($taxNo) && !is_string($taxNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxNo, true), gettype($taxNo)), __LINE__);
        }
        $this->taxNo = $taxNo;
        return $this;
    }
    /**
     * Get taxOffice value
     * @return string|null
     */
    public function getTaxOffice()
    {
        return $this->taxOffice;
    }
    /**
     * Set taxOffice value
     * @param string $taxOffice
     * @return \StructType\BuyerAddressData
     */
    public function setTaxOffice($taxOffice = null)
    {
        // validation for constraint: string
        if (!is_null($taxOffice) && !is_string($taxOffice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxOffice, true), gettype($taxOffice)), __LINE__);
        }
        $this->taxOffice = $taxOffice;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BuyerAddressData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
