<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BaseRequest StructType
 * @subpackage Structs
 */
class BaseRequest extends AbstractStructBase
{
    /**
     * The authentication
     * @var \StructType\Authentication
     */
    public $authentication;
    /**
     * Constructor method for BaseRequest
     * @uses BaseRequest::setAuthentication()
     * @param \StructType\Authentication $authentication
     */
    public function __construct(\StructType\Authentication $authentication = null)
    {
        $this
            ->setAuthentication($authentication);
    }
    /**
     * Get authentication value
     * @return \StructType\Authentication|null
     */
    public function getAuthentication()
    {
        return $this->authentication;
    }
    /**
     * Set authentication value
     * @param \StructType\Authentication $authentication
     * @return \StructType\BaseRequest
     */
    public function setAuthentication(\StructType\Authentication $authentication = null)
    {
        $this->authentication = $authentication;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BaseRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
