<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderItemAcceptRequest StructType
 * @subpackage Structs
 */
class OrderItemAcceptRequest extends AbstractStructBase
{
    /**
     * The auth
     * @var \StructType\Authentication
     */
    public $auth;
    /**
     * The orderItemList
     * @var \StructType\OrderItemDataListRequest
     */
    public $orderItemList;
    /**
     * The numberOfPackages
     * @var int
     */
    public $numberOfPackages;
    /**
     * Constructor method for OrderItemAcceptRequest
     * @uses OrderItemAcceptRequest::setAuth()
     * @uses OrderItemAcceptRequest::setOrderItemList()
     * @uses OrderItemAcceptRequest::setNumberOfPackages()
     * @param \StructType\Authentication $auth
     * @param \StructType\OrderItemDataListRequest $orderItemList
     * @param int $numberOfPackages
     */
    public function __construct(\StructType\Authentication $auth = null, \StructType\OrderItemDataListRequest $orderItemList = null, $numberOfPackages = null)
    {
        $this
            ->setAuth($auth)
            ->setOrderItemList($orderItemList)
            ->setNumberOfPackages($numberOfPackages);
    }
    /**
     * Get auth value
     * @return \StructType\Authentication|null
     */
    public function getAuth()
    {
        return $this->auth;
    }
    /**
     * Set auth value
     * @param \StructType\Authentication $auth
     * @return \StructType\OrderItemAcceptRequest
     */
    public function setAuth(\StructType\Authentication $auth = null)
    {
        $this->auth = $auth;
        return $this;
    }
    /**
     * Get orderItemList value
     * @return \StructType\OrderItemDataListRequest|null
     */
    public function getOrderItemList()
    {
        return $this->orderItemList;
    }
    /**
     * Set orderItemList value
     * @param \StructType\OrderItemDataListRequest $orderItemList
     * @return \StructType\OrderItemAcceptRequest
     */
    public function setOrderItemList(\StructType\OrderItemDataListRequest $orderItemList = null)
    {
        $this->orderItemList = $orderItemList;
        return $this;
    }
    /**
     * Get numberOfPackages value
     * @return int|null
     */
    public function getNumberOfPackages()
    {
        return $this->numberOfPackages;
    }
    /**
     * Set numberOfPackages value
     * @param int $numberOfPackages
     * @return \StructType\OrderItemAcceptRequest
     */
    public function setNumberOfPackages($numberOfPackages = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfPackages) && !(is_int($numberOfPackages) || ctype_digit($numberOfPackages))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfPackages, true), gettype($numberOfPackages)), __LINE__);
        }
        $this->numberOfPackages = $numberOfPackages;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OrderItemAcceptRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
