<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemWithComplementaryData StructType
 * @subpackage Structs
 */
class ItemWithComplementaryData extends AbstractStructBase
{
    /**
     * The sellerCode
     * @var string
     */
    public $sellerCode;
    /**
     * The productTitle
     * @var string
     */
    public $productTitle;
    /**
     * The category
     * @var string
     */
    public $category;
    /**
     * The price
     * @var float
     */
    public $price;
    /**
     * The paidDate
     * @var string
     */
    public $paidDate;
    /**
     * The acceptedDate
     * @var string
     */
    public $acceptedDate;
    /**
     * The status
     * @var int
     */
    public $status;
    /**
     * The certificateNo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var string[]
     */
    public $certificateNo;
    /**
     * The compItemId
     * @var int
     */
    public $compItemId;
    /**
     * The compAcceptedDate
     * @var string
     */
    public $compAcceptedDate;
    /**
     * The buyerAddress
     * @var \StructType\BuyerAddressData
     */
    public $buyerAddress;
    /**
     * Constructor method for ItemWithComplementaryData
     * @uses ItemWithComplementaryData::setSellerCode()
     * @uses ItemWithComplementaryData::setProductTitle()
     * @uses ItemWithComplementaryData::setCategory()
     * @uses ItemWithComplementaryData::setPrice()
     * @uses ItemWithComplementaryData::setPaidDate()
     * @uses ItemWithComplementaryData::setAcceptedDate()
     * @uses ItemWithComplementaryData::setStatus()
     * @uses ItemWithComplementaryData::setCertificateNo()
     * @uses ItemWithComplementaryData::setCompItemId()
     * @uses ItemWithComplementaryData::setCompAcceptedDate()
     * @uses ItemWithComplementaryData::setBuyerAddress()
     * @param string $sellerCode
     * @param string $productTitle
     * @param string $category
     * @param float $price
     * @param string $paidDate
     * @param string $acceptedDate
     * @param int $status
     * @param string[] $certificateNo
     * @param int $compItemId
     * @param string $compAcceptedDate
     * @param \StructType\BuyerAddressData $buyerAddress
     */
    public function __construct($sellerCode = null, $productTitle = null, $category = null, $price = null, $paidDate = null, $acceptedDate = null, $status = null, array $certificateNo = array(), $compItemId = null, $compAcceptedDate = null, \StructType\BuyerAddressData $buyerAddress = null)
    {
        $this
            ->setSellerCode($sellerCode)
            ->setProductTitle($productTitle)
            ->setCategory($category)
            ->setPrice($price)
            ->setPaidDate($paidDate)
            ->setAcceptedDate($acceptedDate)
            ->setStatus($status)
            ->setCertificateNo($certificateNo)
            ->setCompItemId($compItemId)
            ->setCompAcceptedDate($compAcceptedDate)
            ->setBuyerAddress($buyerAddress);
    }
    /**
     * Get sellerCode value
     * @return string|null
     */
    public function getSellerCode()
    {
        return $this->sellerCode;
    }
    /**
     * Set sellerCode value
     * @param string $sellerCode
     * @return \StructType\ItemWithComplementaryData
     */
    public function setSellerCode($sellerCode = null)
    {
        // validation for constraint: string
        if (!is_null($sellerCode) && !is_string($sellerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sellerCode, true), gettype($sellerCode)), __LINE__);
        }
        $this->sellerCode = $sellerCode;
        return $this;
    }
    /**
     * Get productTitle value
     * @return string|null
     */
    public function getProductTitle()
    {
        return $this->productTitle;
    }
    /**
     * Set productTitle value
     * @param string $productTitle
     * @return \StructType\ItemWithComplementaryData
     */
    public function setProductTitle($productTitle = null)
    {
        // validation for constraint: string
        if (!is_null($productTitle) && !is_string($productTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productTitle, true), gettype($productTitle)), __LINE__);
        }
        $this->productTitle = $productTitle;
        return $this;
    }
    /**
     * Get category value
     * @return string|null
     */
    public function getCategory()
    {
        return $this->category;
    }
    /**
     * Set category value
     * @param string $category
     * @return \StructType\ItemWithComplementaryData
     */
    public function setCategory($category = null)
    {
        // validation for constraint: string
        if (!is_null($category) && !is_string($category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($category, true), gettype($category)), __LINE__);
        }
        $this->category = $category;
        return $this;
    }
    /**
     * Get price value
     * @return float|null
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * Set price value
     * @param float $price
     * @return \StructType\ItemWithComplementaryData
     */
    public function setPrice($price = null)
    {
        // validation for constraint: float
        if (!is_null($price) && !(is_float($price) || is_numeric($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        $this->price = $price;
        return $this;
    }
    /**
     * Get paidDate value
     * @return string|null
     */
    public function getPaidDate()
    {
        return $this->paidDate;
    }
    /**
     * Set paidDate value
     * @param string $paidDate
     * @return \StructType\ItemWithComplementaryData
     */
    public function setPaidDate($paidDate = null)
    {
        // validation for constraint: string
        if (!is_null($paidDate) && !is_string($paidDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paidDate, true), gettype($paidDate)), __LINE__);
        }
        $this->paidDate = $paidDate;
        return $this;
    }
    /**
     * Get acceptedDate value
     * @return string|null
     */
    public function getAcceptedDate()
    {
        return $this->acceptedDate;
    }
    /**
     * Set acceptedDate value
     * @param string $acceptedDate
     * @return \StructType\ItemWithComplementaryData
     */
    public function setAcceptedDate($acceptedDate = null)
    {
        // validation for constraint: string
        if (!is_null($acceptedDate) && !is_string($acceptedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($acceptedDate, true), gettype($acceptedDate)), __LINE__);
        }
        $this->acceptedDate = $acceptedDate;
        return $this;
    }
    /**
     * Get status value
     * @return int|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param int $status
     * @return \StructType\ItemWithComplementaryData
     */
    public function setStatus($status = null)
    {
        // validation for constraint: int
        if (!is_null($status) && !(is_int($status) || ctype_digit($status))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get certificateNo value
     * @return string[]|null
     */
    public function getCertificateNo()
    {
        return $this->certificateNo;
    }
    /**
     * This method is responsible for validating the values passed to the setCertificateNo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCertificateNo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCertificateNoForArrayConstraintsFromSetCertificateNo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemWithComplementaryDataCertificateNoItem) {
            // validation for constraint: itemType
            if (!is_string($itemWithComplementaryDataCertificateNoItem)) {
                $invalidValues[] = is_object($itemWithComplementaryDataCertificateNoItem) ? get_class($itemWithComplementaryDataCertificateNoItem) : sprintf('%s(%s)', gettype($itemWithComplementaryDataCertificateNoItem), var_export($itemWithComplementaryDataCertificateNoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The certificateNo property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set certificateNo value
     * @throws \InvalidArgumentException
     * @param string[] $certificateNo
     * @return \StructType\ItemWithComplementaryData
     */
    public function setCertificateNo(array $certificateNo = array())
    {
        // validation for constraint: array
        if ('' !== ($certificateNoArrayErrorMessage = self::validateCertificateNoForArrayConstraintsFromSetCertificateNo($certificateNo))) {
            throw new \InvalidArgumentException($certificateNoArrayErrorMessage, __LINE__);
        }
        $this->certificateNo = $certificateNo;
        return $this;
    }
    /**
     * Add item to certificateNo value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\ItemWithComplementaryData
     */
    public function addToCertificateNo($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The certificateNo property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->certificateNo[] = $item;
        return $this;
    }
    /**
     * Get compItemId value
     * @return int|null
     */
    public function getCompItemId()
    {
        return $this->compItemId;
    }
    /**
     * Set compItemId value
     * @param int $compItemId
     * @return \StructType\ItemWithComplementaryData
     */
    public function setCompItemId($compItemId = null)
    {
        // validation for constraint: int
        if (!is_null($compItemId) && !(is_int($compItemId) || ctype_digit($compItemId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($compItemId, true), gettype($compItemId)), __LINE__);
        }
        $this->compItemId = $compItemId;
        return $this;
    }
    /**
     * Get compAcceptedDate value
     * @return string|null
     */
    public function getCompAcceptedDate()
    {
        return $this->compAcceptedDate;
    }
    /**
     * Set compAcceptedDate value
     * @param string $compAcceptedDate
     * @return \StructType\ItemWithComplementaryData
     */
    public function setCompAcceptedDate($compAcceptedDate = null)
    {
        // validation for constraint: string
        if (!is_null($compAcceptedDate) && !is_string($compAcceptedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($compAcceptedDate, true), gettype($compAcceptedDate)), __LINE__);
        }
        $this->compAcceptedDate = $compAcceptedDate;
        return $this;
    }
    /**
     * Get buyerAddress value
     * @return \StructType\BuyerAddressData|null
     */
    public function getBuyerAddress()
    {
        return $this->buyerAddress;
    }
    /**
     * Set buyerAddress value
     * @param \StructType\BuyerAddressData $buyerAddress
     * @return \StructType\ItemWithComplementaryData
     */
    public function setBuyerAddress(\StructType\BuyerAddressData $buyerAddress = null)
    {
        $this->buyerAddress = $buyerAddress;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ItemWithComplementaryData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
