<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Detailed ServiceType
 * @subpackage Services
 */
class Detailed extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named DetailedOrderList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DetailedOrderListRequest $detailedOrderListRequest
     * @return \StructType\DetailedOrderListResponse|bool
     */
    public function DetailedOrderList(\StructType\DetailedOrderListRequest $detailedOrderListRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->DetailedOrderList($detailedOrderListRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\DetailedOrderListResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
