<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderItemRejectRequest StructType
 * @subpackage Structs
 */
class OrderItemRejectRequest extends AbstractStructBase
{
    /**
     * The auth
     * @var \StructType\Authentication
     */
    public $auth;
    /**
     * The orderItemList
     * @var \StructType\OrderItemDataRequestForRejection
     */
    public $orderItemList;
    /**
     * The rejectReason
     * @var string
     */
    public $rejectReason;
    /**
     * The rejectReasonType
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $rejectReasonType;
    /**
     * Constructor method for OrderItemRejectRequest
     * @uses OrderItemRejectRequest::setAuth()
     * @uses OrderItemRejectRequest::setOrderItemList()
     * @uses OrderItemRejectRequest::setRejectReason()
     * @uses OrderItemRejectRequest::setRejectReasonType()
     * @param \StructType\Authentication $auth
     * @param \StructType\OrderItemDataRequestForRejection $orderItemList
     * @param string $rejectReason
     * @param string $rejectReasonType
     */
    public function __construct(\StructType\Authentication $auth = null, \StructType\OrderItemDataRequestForRejection $orderItemList = null, $rejectReason = null, $rejectReasonType = null)
    {
        $this
            ->setAuth($auth)
            ->setOrderItemList($orderItemList)
            ->setRejectReason($rejectReason)
            ->setRejectReasonType($rejectReasonType);
    }
    /**
     * Get auth value
     * @return \StructType\Authentication|null
     */
    public function getAuth()
    {
        return $this->auth;
    }
    /**
     * Set auth value
     * @param \StructType\Authentication $auth
     * @return \StructType\OrderItemRejectRequest
     */
    public function setAuth(\StructType\Authentication $auth = null)
    {
        $this->auth = $auth;
        return $this;
    }
    /**
     * Get orderItemList value
     * @return \StructType\OrderItemDataRequestForRejection|null
     */
    public function getOrderItemList()
    {
        return $this->orderItemList;
    }
    /**
     * Set orderItemList value
     * @param \StructType\OrderItemDataRequestForRejection $orderItemList
     * @return \StructType\OrderItemRejectRequest
     */
    public function setOrderItemList(\StructType\OrderItemDataRequestForRejection $orderItemList = null)
    {
        $this->orderItemList = $orderItemList;
        return $this;
    }
    /**
     * Get rejectReason value
     * @return string|null
     */
    public function getRejectReason()
    {
        return $this->rejectReason;
    }
    /**
     * Set rejectReason value
     * @param string $rejectReason
     * @return \StructType\OrderItemRejectRequest
     */
    public function setRejectReason($rejectReason = null)
    {
        // validation for constraint: string
        if (!is_null($rejectReason) && !is_string($rejectReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rejectReason, true), gettype($rejectReason)), __LINE__);
        }
        $this->rejectReason = $rejectReason;
        return $this;
    }
    /**
     * Get rejectReasonType value
     * @return string|null
     */
    public function getRejectReasonType()
    {
        return $this->rejectReasonType;
    }
    /**
     * Set rejectReasonType value
     * @param string $rejectReasonType
     * @return \StructType\OrderItemRejectRequest
     */
    public function setRejectReasonType($rejectReasonType = null)
    {
        // validation for constraint: string
        if (!is_null($rejectReasonType) && !is_string($rejectReasonType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rejectReasonType, true), gettype($rejectReasonType)), __LINE__);
        }
        $this->rejectReasonType = $rejectReasonType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OrderItemRejectRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
