<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SkuAttributeList StructType
 * @subpackage Structs
 */
class SkuAttributeList extends AbstractStructBase
{
    /**
     * The attribute
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\SkuAttribute[]
     */
    public $attribute;
    /**
     * Constructor method for SkuAttributeList
     * @uses SkuAttributeList::setAttribute()
     * @param \StructType\SkuAttribute[] $attribute
     */
    public function __construct(array $attribute = array())
    {
        $this
            ->setAttribute($attribute);
    }
    /**
     * Get attribute value
     * @return \StructType\SkuAttribute[]|null
     */
    public function getAttribute()
    {
        return $this->attribute;
    }
    /**
     * This method is responsible for validating the values passed to the setAttribute method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAttribute method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAttributeForArrayConstraintsFromSetAttribute(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $skuAttributeListAttributeItem) {
            // validation for constraint: itemType
            if (!$skuAttributeListAttributeItem instanceof \StructType\SkuAttribute) {
                $invalidValues[] = is_object($skuAttributeListAttributeItem) ? get_class($skuAttributeListAttributeItem) : sprintf('%s(%s)', gettype($skuAttributeListAttributeItem), var_export($skuAttributeListAttributeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The attribute property can only contain items of type \StructType\SkuAttribute, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set attribute value
     * @throws \InvalidArgumentException
     * @param \StructType\SkuAttribute[] $attribute
     * @return \StructType\SkuAttributeList
     */
    public function setAttribute(array $attribute = array())
    {
        // validation for constraint: array
        if ('' !== ($attributeArrayErrorMessage = self::validateAttributeForArrayConstraintsFromSetAttribute($attribute))) {
            throw new \InvalidArgumentException($attributeArrayErrorMessage, __LINE__);
        }
        $this->attribute = $attribute;
        return $this;
    }
    /**
     * Add item to attribute value
     * @throws \InvalidArgumentException
     * @param \StructType\SkuAttribute $item
     * @return \StructType\SkuAttributeList
     */
    public function addToAttribute(\StructType\SkuAttribute $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SkuAttribute) {
            throw new \InvalidArgumentException(sprintf('The attribute property can only contain items of type \StructType\SkuAttribute, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->attribute[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SkuAttributeList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
