<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BuyerWithTaxFields StructType
 * @subpackage Structs
 */
class BuyerWithTaxFields extends AbstractStructBase
{
    /**
     * The id
     * @var int
     */
    public $id;
    /**
     * The fullName
     * @var string
     */
    public $fullName;
    /**
     * The taxId
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $taxId;
    /**
     * The taxOffice
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $taxOffice;
    /**
     * The email
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $email;
    /**
     * The tcId
     * @var string
     */
    public $tcId;
    /**
     * Constructor method for BuyerWithTaxFields
     * @uses BuyerWithTaxFields::setId()
     * @uses BuyerWithTaxFields::setFullName()
     * @uses BuyerWithTaxFields::setTaxId()
     * @uses BuyerWithTaxFields::setTaxOffice()
     * @uses BuyerWithTaxFields::setEmail()
     * @uses BuyerWithTaxFields::setTcId()
     * @param int $id
     * @param string $fullName
     * @param string $taxId
     * @param string $taxOffice
     * @param string $email
     * @param string $tcId
     */
    public function __construct($id = null, $fullName = null, $taxId = null, $taxOffice = null, $email = null, $tcId = null)
    {
        $this
            ->setId($id)
            ->setFullName($fullName)
            ->setTaxId($taxId)
            ->setTaxOffice($taxOffice)
            ->setEmail($email)
            ->setTcId($tcId);
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\BuyerWithTaxFields
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get fullName value
     * @return string|null
     */
    public function getFullName()
    {
        return $this->fullName;
    }
    /**
     * Set fullName value
     * @param string $fullName
     * @return \StructType\BuyerWithTaxFields
     */
    public function setFullName($fullName = null)
    {
        // validation for constraint: string
        if (!is_null($fullName) && !is_string($fullName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fullName, true), gettype($fullName)), __LINE__);
        }
        $this->fullName = $fullName;
        return $this;
    }
    /**
     * Get taxId value
     * @return string|null
     */
    public function getTaxId()
    {
        return $this->taxId;
    }
    /**
     * Set taxId value
     * @param string $taxId
     * @return \StructType\BuyerWithTaxFields
     */
    public function setTaxId($taxId = null)
    {
        // validation for constraint: string
        if (!is_null($taxId) && !is_string($taxId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxId, true), gettype($taxId)), __LINE__);
        }
        $this->taxId = $taxId;
        return $this;
    }
    /**
     * Get taxOffice value
     * @return string|null
     */
    public function getTaxOffice()
    {
        return $this->taxOffice;
    }
    /**
     * Set taxOffice value
     * @param string $taxOffice
     * @return \StructType\BuyerWithTaxFields
     */
    public function setTaxOffice($taxOffice = null)
    {
        // validation for constraint: string
        if (!is_null($taxOffice) && !is_string($taxOffice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxOffice, true), gettype($taxOffice)), __LINE__);
        }
        $this->taxOffice = $taxOffice;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \StructType\BuyerWithTaxFields
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get tcId value
     * @return string|null
     */
    public function getTcId()
    {
        return $this->tcId;
    }
    /**
     * Set tcId value
     * @param string $tcId
     * @return \StructType\BuyerWithTaxFields
     */
    public function setTcId($tcId = null)
    {
        // validation for constraint: string
        if (!is_null($tcId) && !is_string($tcId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tcId, true), gettype($tcId)), __LINE__);
        }
        $this->tcId = $tcId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BuyerWithTaxFields
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
