<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MakeShipmentInfoRequest StructType
 * @subpackage Structs
 */
class MakeShipmentInfoRequest extends AbstractStructBase
{
    /**
     * The shipmentCompany
     * @var \StructType\ShipmentCompanyRequest
     */
    public $shipmentCompany;
    /**
     * The campaignNumber
     * @var string
     */
    public $campaignNumber;
    /**
     * The trackingNumber
     * @var string
     */
    public $trackingNumber;
    /**
     * The shipmentMethod
     * @var int
     */
    public $shipmentMethod;
    /**
     * Constructor method for MakeShipmentInfoRequest
     * @uses MakeShipmentInfoRequest::setShipmentCompany()
     * @uses MakeShipmentInfoRequest::setCampaignNumber()
     * @uses MakeShipmentInfoRequest::setTrackingNumber()
     * @uses MakeShipmentInfoRequest::setShipmentMethod()
     * @param \StructType\ShipmentCompanyRequest $shipmentCompany
     * @param string $campaignNumber
     * @param string $trackingNumber
     * @param int $shipmentMethod
     */
    public function __construct(\StructType\ShipmentCompanyRequest $shipmentCompany = null, $campaignNumber = null, $trackingNumber = null, $shipmentMethod = null)
    {
        $this
            ->setShipmentCompany($shipmentCompany)
            ->setCampaignNumber($campaignNumber)
            ->setTrackingNumber($trackingNumber)
            ->setShipmentMethod($shipmentMethod);
    }
    /**
     * Get shipmentCompany value
     * @return \StructType\ShipmentCompanyRequest|null
     */
    public function getShipmentCompany()
    {
        return $this->shipmentCompany;
    }
    /**
     * Set shipmentCompany value
     * @param \StructType\ShipmentCompanyRequest $shipmentCompany
     * @return \StructType\MakeShipmentInfoRequest
     */
    public function setShipmentCompany(\StructType\ShipmentCompanyRequest $shipmentCompany = null)
    {
        $this->shipmentCompany = $shipmentCompany;
        return $this;
    }
    /**
     * Get campaignNumber value
     * @return string|null
     */
    public function getCampaignNumber()
    {
        return $this->campaignNumber;
    }
    /**
     * Set campaignNumber value
     * @param string $campaignNumber
     * @return \StructType\MakeShipmentInfoRequest
     */
    public function setCampaignNumber($campaignNumber = null)
    {
        // validation for constraint: string
        if (!is_null($campaignNumber) && !is_string($campaignNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($campaignNumber, true), gettype($campaignNumber)), __LINE__);
        }
        $this->campaignNumber = $campaignNumber;
        return $this;
    }
    /**
     * Get trackingNumber value
     * @return string|null
     */
    public function getTrackingNumber()
    {
        return $this->trackingNumber;
    }
    /**
     * Set trackingNumber value
     * @param string $trackingNumber
     * @return \StructType\MakeShipmentInfoRequest
     */
    public function setTrackingNumber($trackingNumber = null)
    {
        // validation for constraint: string
        if (!is_null($trackingNumber) && !is_string($trackingNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trackingNumber, true), gettype($trackingNumber)), __LINE__);
        }
        $this->trackingNumber = $trackingNumber;
        return $this;
    }
    /**
     * Get shipmentMethod value
     * @return int|null
     */
    public function getShipmentMethod()
    {
        return $this->shipmentMethod;
    }
    /**
     * Set shipmentMethod value
     * @param int $shipmentMethod
     * @return \StructType\MakeShipmentInfoRequest
     */
    public function setShipmentMethod($shipmentMethod = null)
    {
        // validation for constraint: int
        if (!is_null($shipmentMethod) && !(is_int($shipmentMethod) || ctype_digit($shipmentMethod))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($shipmentMethod, true), gettype($shipmentMethod)), __LINE__);
        }
        $this->shipmentMethod = $shipmentMethod;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MakeShipmentInfoRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
