<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderListResponse StructType
 * @subpackage Structs
 */
class OrderListResponse extends AbstractStructBase
{
    /**
     * The result
     * @var \StructType\ResultInfo
     */
    public $result;
    /**
     * The pagingData
     * @var \StructType\PagingData
     */
    public $pagingData;
    /**
     * The orderList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\OrderDataList
     */
    public $orderList;
    /**
     * Constructor method for OrderListResponse
     * @uses OrderListResponse::setResult()
     * @uses OrderListResponse::setPagingData()
     * @uses OrderListResponse::setOrderList()
     * @param \StructType\ResultInfo $result
     * @param \StructType\PagingData $pagingData
     * @param \StructType\OrderDataList $orderList
     */
    public function __construct(\StructType\ResultInfo $result = null, \StructType\PagingData $pagingData = null, \StructType\OrderDataList $orderList = null)
    {
        $this
            ->setResult($result)
            ->setPagingData($pagingData)
            ->setOrderList($orderList);
    }
    /**
     * Get result value
     * @return \StructType\ResultInfo|null
     */
    public function getResult()
    {
        return $this->result;
    }
    /**
     * Set result value
     * @param \StructType\ResultInfo $result
     * @return \StructType\OrderListResponse
     */
    public function setResult(\StructType\ResultInfo $result = null)
    {
        $this->result = $result;
        return $this;
    }
    /**
     * Get pagingData value
     * @return \StructType\PagingData|null
     */
    public function getPagingData()
    {
        return $this->pagingData;
    }
    /**
     * Set pagingData value
     * @param \StructType\PagingData $pagingData
     * @return \StructType\OrderListResponse
     */
    public function setPagingData(\StructType\PagingData $pagingData = null)
    {
        $this->pagingData = $pagingData;
        return $this;
    }
    /**
     * Get orderList value
     * @return \StructType\OrderDataList|null
     */
    public function getOrderList()
    {
        return $this->orderList;
    }
    /**
     * Set orderList value
     * @param \StructType\OrderDataList $orderList
     * @return \StructType\OrderListResponse
     */
    public function setOrderList(\StructType\OrderDataList $orderList = null)
    {
        $this->orderList = $orderList;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OrderListResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
