<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderItemAcceptRequest StructType
 * @subpackage Structs
 */
class OrderItemAcceptRequest extends AbstractStructBase
{
    /**
     * The auth
     * @var \StructType\Authentication
     */
    public $auth;
    /**
     * The orderItemList
     * @var \StructType\OrderItemDataListRequest
     */
    public $orderItemList;
    /**
     * Constructor method for OrderItemAcceptRequest
     * @uses OrderItemAcceptRequest::setAuth()
     * @uses OrderItemAcceptRequest::setOrderItemList()
     * @param \StructType\Authentication $auth
     * @param \StructType\OrderItemDataListRequest $orderItemList
     */
    public function __construct(\StructType\Authentication $auth = null, \StructType\OrderItemDataListRequest $orderItemList = null)
    {
        $this
            ->setAuth($auth)
            ->setOrderItemList($orderItemList);
    }
    /**
     * Get auth value
     * @return \StructType\Authentication|null
     */
    public function getAuth()
    {
        return $this->auth;
    }
    /**
     * Set auth value
     * @param \StructType\Authentication $auth
     * @return \StructType\OrderItemAcceptRequest
     */
    public function setAuth(\StructType\Authentication $auth = null)
    {
        $this->auth = $auth;
        return $this;
    }
    /**
     * Get orderItemList value
     * @return \StructType\OrderItemDataListRequest|null
     */
    public function getOrderItemList()
    {
        return $this->orderItemList;
    }
    /**
     * Set orderItemList value
     * @param \StructType\OrderItemDataListRequest $orderItemList
     * @return \StructType\OrderItemAcceptRequest
     */
    public function setOrderItemList(\StructType\OrderItemDataListRequest $orderItemList = null)
    {
        $this->orderItemList = $orderItemList;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OrderItemAcceptRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
