<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Order ServiceType
 * @subpackage Services
 */
class Order extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named OrderList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OrderListRequest $orderListRequest
     * @return \StructType\OrderListResponse|bool
     */
    public function OrderList(\StructType\OrderListRequest $orderListRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->OrderList($orderListRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OrderItemAccept
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OrderItemAcceptRequest $orderItemAcceptRequest
     * @return \StructType\OrderItemAcceptResponse|bool
     */
    public function OrderItemAccept(\StructType\OrderItemAcceptRequest $orderItemAcceptRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->OrderItemAccept($orderItemAcceptRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OrderItemReject
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OrderItemRejectRequest $orderItemRejectRequest
     * @return \StructType\OrderItemRejectResponse|bool
     */
    public function OrderItemReject(\StructType\OrderItemRejectRequest $orderItemRejectRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->OrderItemReject($orderItemRejectRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named OrderDetail
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OrderDetailRequest $orderDetailRequest
     * @return \StructType\OrderDetailResponse|bool
     */
    public function OrderDetail(\StructType\OrderDetailRequest $orderDetailRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->OrderDetail($orderDetailRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\OrderDetailResponse|\StructType\OrderItemAcceptResponse|\StructType\OrderItemRejectResponse|\StructType\OrderListResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
