<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderItemDataRequestForRejection StructType
 * @subpackage Structs
 */
class OrderItemDataRequestForRejection extends AbstractStructBase
{
    /**
     * The orderItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\OrderItemDataRequest[]
     */
    public $orderItem;
    /**
     * Constructor method for OrderItemDataRequestForRejection
     * @uses OrderItemDataRequestForRejection::setOrderItem()
     * @param \StructType\OrderItemDataRequest[] $orderItem
     */
    public function __construct(array $orderItem = array())
    {
        $this
            ->setOrderItem($orderItem);
    }
    /**
     * Get orderItem value
     * @return \StructType\OrderItemDataRequest[]|null
     */
    public function getOrderItem()
    {
        return $this->orderItem;
    }
    /**
     * This method is responsible for validating the values passed to the setOrderItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrderItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrderItemForArrayConstraintsFromSetOrderItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $orderItemDataRequestForRejectionOrderItemItem) {
            // validation for constraint: itemType
            if (!$orderItemDataRequestForRejectionOrderItemItem instanceof \StructType\OrderItemDataRequest) {
                $invalidValues[] = is_object($orderItemDataRequestForRejectionOrderItemItem) ? get_class($orderItemDataRequestForRejectionOrderItemItem) : sprintf('%s(%s)', gettype($orderItemDataRequestForRejectionOrderItemItem), var_export($orderItemDataRequestForRejectionOrderItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The orderItem property can only contain items of type \StructType\OrderItemDataRequest, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set orderItem value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderItemDataRequest[] $orderItem
     * @return \StructType\OrderItemDataRequestForRejection
     */
    public function setOrderItem(array $orderItem = array())
    {
        // validation for constraint: array
        if ('' !== ($orderItemArrayErrorMessage = self::validateOrderItemForArrayConstraintsFromSetOrderItem($orderItem))) {
            throw new \InvalidArgumentException($orderItemArrayErrorMessage, __LINE__);
        }
        $this->orderItem = $orderItem;
        return $this;
    }
    /**
     * Add item to orderItem value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderItemDataRequest $item
     * @return \StructType\OrderItemDataRequestForRejection
     */
    public function addToOrderItem(\StructType\OrderItemDataRequest $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrderItemDataRequest) {
            throw new \InvalidArgumentException(sprintf('The orderItem property can only contain items of type \StructType\OrderItemDataRequest, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->orderItem[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OrderItemDataRequestForRejection
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
