<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceOrderItemDataList StructType
 * @subpackage Structs
 */
class ServiceOrderItemDataList extends AbstractStructBase
{
    /**
     * The serviceItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\ServiceOrderItemData[]
     */
    public $serviceItem;
    /**
     * Constructor method for ServiceOrderItemDataList
     * @uses ServiceOrderItemDataList::setServiceItem()
     * @param \StructType\ServiceOrderItemData[] $serviceItem
     */
    public function __construct(array $serviceItem = array())
    {
        $this
            ->setServiceItem($serviceItem);
    }
    /**
     * Get serviceItem value
     * @return \StructType\ServiceOrderItemData[]|null
     */
    public function getServiceItem()
    {
        return $this->serviceItem;
    }
    /**
     * This method is responsible for validating the values passed to the setServiceItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setServiceItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateServiceItemForArrayConstraintsFromSetServiceItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $serviceOrderItemDataListServiceItemItem) {
            // validation for constraint: itemType
            if (!$serviceOrderItemDataListServiceItemItem instanceof \StructType\ServiceOrderItemData) {
                $invalidValues[] = is_object($serviceOrderItemDataListServiceItemItem) ? get_class($serviceOrderItemDataListServiceItemItem) : sprintf('%s(%s)', gettype($serviceOrderItemDataListServiceItemItem), var_export($serviceOrderItemDataListServiceItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The serviceItem property can only contain items of type \StructType\ServiceOrderItemData, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set serviceItem value
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceOrderItemData[] $serviceItem
     * @return \StructType\ServiceOrderItemDataList
     */
    public function setServiceItem(array $serviceItem = array())
    {
        // validation for constraint: array
        if ('' !== ($serviceItemArrayErrorMessage = self::validateServiceItemForArrayConstraintsFromSetServiceItem($serviceItem))) {
            throw new \InvalidArgumentException($serviceItemArrayErrorMessage, __LINE__);
        }
        $this->serviceItem = $serviceItem;
        return $this;
    }
    /**
     * Add item to serviceItem value
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceOrderItemData $item
     * @return \StructType\ServiceOrderItemDataList
     */
    public function addToServiceItem(\StructType\ServiceOrderItemData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ServiceOrderItemData) {
            throw new \InvalidArgumentException(sprintf('The serviceItem property can only contain items of type \StructType\ServiceOrderItemData, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->serviceItem[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ServiceOrderItemDataList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
