<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DetailedOrderDataList StructType
 * @subpackage Structs
 */
class DetailedOrderDataList extends AbstractStructBase
{
    /**
     * The order
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DetailedOrderData[]
     */
    public $order;
    /**
     * Constructor method for DetailedOrderDataList
     * @uses DetailedOrderDataList::setOrder()
     * @param \StructType\DetailedOrderData[] $order
     */
    public function __construct(array $order = array())
    {
        $this
            ->setOrder($order);
    }
    /**
     * Get order value
     * @return \StructType\DetailedOrderData[]|null
     */
    public function getOrder()
    {
        return $this->order;
    }
    /**
     * This method is responsible for validating the values passed to the setOrder method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrder method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrderForArrayConstraintsFromSetOrder(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $detailedOrderDataListOrderItem) {
            // validation for constraint: itemType
            if (!$detailedOrderDataListOrderItem instanceof \StructType\DetailedOrderData) {
                $invalidValues[] = is_object($detailedOrderDataListOrderItem) ? get_class($detailedOrderDataListOrderItem) : sprintf('%s(%s)', gettype($detailedOrderDataListOrderItem), var_export($detailedOrderDataListOrderItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The order property can only contain items of type \StructType\DetailedOrderData, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set order value
     * @throws \InvalidArgumentException
     * @param \StructType\DetailedOrderData[] $order
     * @return \StructType\DetailedOrderDataList
     */
    public function setOrder(array $order = array())
    {
        // validation for constraint: array
        if ('' !== ($orderArrayErrorMessage = self::validateOrderForArrayConstraintsFromSetOrder($order))) {
            throw new \InvalidArgumentException($orderArrayErrorMessage, __LINE__);
        }
        $this->order = $order;
        return $this;
    }
    /**
     * Add item to order value
     * @throws \InvalidArgumentException
     * @param \StructType\DetailedOrderData $item
     * @return \StructType\DetailedOrderDataList
     */
    public function addToOrder(\StructType\DetailedOrderData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DetailedOrderData) {
            throw new \InvalidArgumentException(sprintf('The order property can only contain items of type \StructType\DetailedOrderData, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->order[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DetailedOrderDataList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
