<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceOrderItemData StructType
 * @subpackage Structs
 */
class ServiceOrderItemData extends AbstractStructBase
{
    /**
     * The orderItemType
     * @var int
     */
    public $orderItemType;
    /**
     * The installmentChargeWithVAT
     * @var float
     */
    public $installmentChargeWithVAT;
    /**
     * The price
     * @var float
     */
    public $price;
    /**
     * The totalDiscountPrice
     * @var float
     */
    public $totalDiscountPrice;
    /**
     * The quantity
     * @var int
     */
    public $quantity;
    /**
     * The sellerInvoiceAmount
     * @var float
     */
    public $sellerInvoiceAmount;
    /**
     * The orderItemList
     * @var \StructType\ProductOrderItemList
     */
    public $orderItemList;
    /**
     * Constructor method for ServiceOrderItemData
     * @uses ServiceOrderItemData::setOrderItemType()
     * @uses ServiceOrderItemData::setInstallmentChargeWithVAT()
     * @uses ServiceOrderItemData::setPrice()
     * @uses ServiceOrderItemData::setTotalDiscountPrice()
     * @uses ServiceOrderItemData::setQuantity()
     * @uses ServiceOrderItemData::setSellerInvoiceAmount()
     * @uses ServiceOrderItemData::setOrderItemList()
     * @param int $orderItemType
     * @param float $installmentChargeWithVAT
     * @param float $price
     * @param float $totalDiscountPrice
     * @param int $quantity
     * @param float $sellerInvoiceAmount
     * @param \StructType\ProductOrderItemList $orderItemList
     */
    public function __construct($orderItemType = null, $installmentChargeWithVAT = null, $price = null, $totalDiscountPrice = null, $quantity = null, $sellerInvoiceAmount = null, \StructType\ProductOrderItemList $orderItemList = null)
    {
        $this
            ->setOrderItemType($orderItemType)
            ->setInstallmentChargeWithVAT($installmentChargeWithVAT)
            ->setPrice($price)
            ->setTotalDiscountPrice($totalDiscountPrice)
            ->setQuantity($quantity)
            ->setSellerInvoiceAmount($sellerInvoiceAmount)
            ->setOrderItemList($orderItemList);
    }
    /**
     * Get orderItemType value
     * @return int|null
     */
    public function getOrderItemType()
    {
        return $this->orderItemType;
    }
    /**
     * Set orderItemType value
     * @param int $orderItemType
     * @return \StructType\ServiceOrderItemData
     */
    public function setOrderItemType($orderItemType = null)
    {
        // validation for constraint: int
        if (!is_null($orderItemType) && !is_numeric($orderItemType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($orderItemType)), __LINE__);
        }
        $this->orderItemType = $orderItemType;
        return $this;
    }
    /**
     * Get installmentChargeWithVAT value
     * @return float|null
     */
    public function getInstallmentChargeWithVAT()
    {
        return $this->installmentChargeWithVAT;
    }
    /**
     * Set installmentChargeWithVAT value
     * @param float $installmentChargeWithVAT
     * @return \StructType\ServiceOrderItemData
     */
    public function setInstallmentChargeWithVAT($installmentChargeWithVAT = null)
    {
        $this->installmentChargeWithVAT = $installmentChargeWithVAT;
        return $this;
    }
    /**
     * Get price value
     * @return float|null
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * Set price value
     * @param float $price
     * @return \StructType\ServiceOrderItemData
     */
    public function setPrice($price = null)
    {
        $this->price = $price;
        return $this;
    }
    /**
     * Get totalDiscountPrice value
     * @return float|null
     */
    public function getTotalDiscountPrice()
    {
        return $this->totalDiscountPrice;
    }
    /**
     * Set totalDiscountPrice value
     * @param float $totalDiscountPrice
     * @return \StructType\ServiceOrderItemData
     */
    public function setTotalDiscountPrice($totalDiscountPrice = null)
    {
        $this->totalDiscountPrice = $totalDiscountPrice;
        return $this;
    }
    /**
     * Get quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param int $quantity
     * @return \StructType\ServiceOrderItemData
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !is_numeric($quantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($quantity)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get sellerInvoiceAmount value
     * @return float|null
     */
    public function getSellerInvoiceAmount()
    {
        return $this->sellerInvoiceAmount;
    }
    /**
     * Set sellerInvoiceAmount value
     * @param float $sellerInvoiceAmount
     * @return \StructType\ServiceOrderItemData
     */
    public function setSellerInvoiceAmount($sellerInvoiceAmount = null)
    {
        $this->sellerInvoiceAmount = $sellerInvoiceAmount;
        return $this;
    }
    /**
     * Get orderItemList value
     * @return \StructType\ProductOrderItemList|null
     */
    public function getOrderItemList()
    {
        return $this->orderItemList;
    }
    /**
     * Set orderItemList value
     * @param \StructType\ProductOrderItemList $orderItemList
     * @return \StructType\ServiceOrderItemData
     */
    public function setOrderItemList(\StructType\ProductOrderItemList $orderItemList = null)
    {
        $this->orderItemList = $orderItemList;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ServiceOrderItemData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
