<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipmentInfoRequest StructType
 * @subpackage Structs
 */
class ShipmentInfoRequest extends AbstractStructBase
{
    /**
     * The shipmentCompany
     * @var \StructType\ShipmentCompanyRequest
     */
    public $shipmentCompany;
    /**
     * The campaignNumber
     * @var string
     */
    public $campaignNumber;
    /**
     * The shipmentCode
     * @var int
     */
    public $shipmentCode;
    /**
     * The shipmentMethod
     * @var int
     */
    public $shipmentMethod;
    /**
     * Constructor method for ShipmentInfoRequest
     * @uses ShipmentInfoRequest::setShipmentCompany()
     * @uses ShipmentInfoRequest::setCampaignNumber()
     * @uses ShipmentInfoRequest::setShipmentCode()
     * @uses ShipmentInfoRequest::setShipmentMethod()
     * @param \StructType\ShipmentCompanyRequest $shipmentCompany
     * @param string $campaignNumber
     * @param int $shipmentCode
     * @param int $shipmentMethod
     */
    public function __construct(\StructType\ShipmentCompanyRequest $shipmentCompany = null, $campaignNumber = null, $shipmentCode = null, $shipmentMethod = null)
    {
        $this
            ->setShipmentCompany($shipmentCompany)
            ->setCampaignNumber($campaignNumber)
            ->setShipmentCode($shipmentCode)
            ->setShipmentMethod($shipmentMethod);
    }
    /**
     * Get shipmentCompany value
     * @return \StructType\ShipmentCompanyRequest|null
     */
    public function getShipmentCompany()
    {
        return $this->shipmentCompany;
    }
    /**
     * Set shipmentCompany value
     * @param \StructType\ShipmentCompanyRequest $shipmentCompany
     * @return \StructType\ShipmentInfoRequest
     */
    public function setShipmentCompany(\StructType\ShipmentCompanyRequest $shipmentCompany = null)
    {
        $this->shipmentCompany = $shipmentCompany;
        return $this;
    }
    /**
     * Get campaignNumber value
     * @return string|null
     */
    public function getCampaignNumber()
    {
        return $this->campaignNumber;
    }
    /**
     * Set campaignNumber value
     * @param string $campaignNumber
     * @return \StructType\ShipmentInfoRequest
     */
    public function setCampaignNumber($campaignNumber = null)
    {
        // validation for constraint: string
        if (!is_null($campaignNumber) && !is_string($campaignNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($campaignNumber)), __LINE__);
        }
        $this->campaignNumber = $campaignNumber;
        return $this;
    }
    /**
     * Get shipmentCode value
     * @return int|null
     */
    public function getShipmentCode()
    {
        return $this->shipmentCode;
    }
    /**
     * Set shipmentCode value
     * @param int $shipmentCode
     * @return \StructType\ShipmentInfoRequest
     */
    public function setShipmentCode($shipmentCode = null)
    {
        // validation for constraint: int
        if (!is_null($shipmentCode) && !is_numeric($shipmentCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($shipmentCode)), __LINE__);
        }
        $this->shipmentCode = $shipmentCode;
        return $this;
    }
    /**
     * Get shipmentMethod value
     * @return int|null
     */
    public function getShipmentMethod()
    {
        return $this->shipmentMethod;
    }
    /**
     * Set shipmentMethod value
     * @param int $shipmentMethod
     * @return \StructType\ShipmentInfoRequest
     */
    public function setShipmentMethod($shipmentMethod = null)
    {
        // validation for constraint: int
        if (!is_null($shipmentMethod) && !is_numeric($shipmentMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($shipmentMethod)), __LINE__);
        }
        $this->shipmentMethod = $shipmentMethod;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ShipmentInfoRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
