<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RequestPagingData StructType
 * @subpackage Structs
 */
class RequestPagingData extends AbstractStructBase
{
    /**
     * The currentPage
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $currentPage;
    /**
     * The pageSize
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $pageSize;
    /**
     * Constructor method for RequestPagingData
     * @uses RequestPagingData::setCurrentPage()
     * @uses RequestPagingData::setPageSize()
     * @param int $currentPage
     * @param int $pageSize
     */
    public function __construct($currentPage = null, $pageSize = null)
    {
        $this
            ->setCurrentPage($currentPage)
            ->setPageSize($pageSize);
    }
    /**
     * Get currentPage value
     * @return int|null
     */
    public function getCurrentPage()
    {
        return $this->currentPage;
    }
    /**
     * Set currentPage value
     * @param int $currentPage
     * @return \StructType\RequestPagingData
     */
    public function setCurrentPage($currentPage = null)
    {
        // validation for constraint: int
        if (!is_null($currentPage) && !is_numeric($currentPage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($currentPage)), __LINE__);
        }
        $this->currentPage = $currentPage;
        return $this;
    }
    /**
     * Get pageSize value
     * @return int|null
     */
    public function getPageSize()
    {
        return $this->pageSize;
    }
    /**
     * Set pageSize value
     * @param int $pageSize
     * @return \StructType\RequestPagingData
     */
    public function setPageSize($pageSize = null)
    {
        // validation for constraint: int
        if (!is_null($pageSize) && !is_numeric($pageSize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($pageSize)), __LINE__);
        }
        $this->pageSize = $pageSize;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RequestPagingData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
