<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductOrderItemList StructType
 * @subpackage Structs
 */
class ProductOrderItemList extends AbstractStructBase
{
    /**
     * The orderItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var int[]
     */
    public $orderItem;
    /**
     * Constructor method for ProductOrderItemList
     * @uses ProductOrderItemList::setOrderItem()
     * @param int[] $orderItem
     */
    public function __construct(array $orderItem = array())
    {
        $this
            ->setOrderItem($orderItem);
    }
    /**
     * Get orderItem value
     * @return int[]|null
     */
    public function getOrderItem()
    {
        return $this->orderItem;
    }
    /**
     * Set orderItem value
     * @throws \InvalidArgumentException
     * @param int[] $orderItem
     * @return \StructType\ProductOrderItemList
     */
    public function setOrderItem(array $orderItem = array())
    {
        foreach ($orderItem as $productOrderItemListOrderItemItem) {
            // validation for constraint: itemType
            if (!is_numeric($productOrderItemListOrderItemItem)) {
                throw new \InvalidArgumentException(sprintf('The orderItem property can only contain items of long, "%s" given', is_object($productOrderItemListOrderItemItem) ? get_class($productOrderItemListOrderItemItem) : gettype($productOrderItemListOrderItemItem)), __LINE__);
            }
        }
        $this->orderItem = $orderItem;
        return $this;
    }
    /**
     * Add item to orderItem value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\ProductOrderItemList
     */
    public function addToOrderItem($item)
    {
        // validation for constraint: itemType
        if (!is_numeric($item)) {
            throw new \InvalidArgumentException(sprintf('The orderItem property can only contain items of long, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->orderItem[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProductOrderItemList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
