<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderItemShipmentRequest StructType
 * @subpackage Structs
 */
class OrderItemShipmentRequest extends AbstractStructBase
{
    /**
     * The id
     * @var int
     */
    public $id;
    /**
     * The shipmentInfo
     * @var \StructType\MakeShipmentInfoRequest
     */
    public $shipmentInfo;
    /**
     * Constructor method for OrderItemShipmentRequest
     * @uses OrderItemShipmentRequest::setId()
     * @uses OrderItemShipmentRequest::setShipmentInfo()
     * @param int $id
     * @param \StructType\MakeShipmentInfoRequest $shipmentInfo
     */
    public function __construct($id = null, \StructType\MakeShipmentInfoRequest $shipmentInfo = null)
    {
        $this
            ->setId($id)
            ->setShipmentInfo($shipmentInfo);
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\OrderItemShipmentRequest
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !is_numeric($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get shipmentInfo value
     * @return \StructType\MakeShipmentInfoRequest|null
     */
    public function getShipmentInfo()
    {
        return $this->shipmentInfo;
    }
    /**
     * Set shipmentInfo value
     * @param \StructType\MakeShipmentInfoRequest $shipmentInfo
     * @return \StructType\OrderItemShipmentRequest
     */
    public function setShipmentInfo(\StructType\MakeShipmentInfoRequest $shipmentInfo = null)
    {
        $this->shipmentInfo = $shipmentInfo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OrderItemShipmentRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
