<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderItemDataList StructType
 * @subpackage Structs
 */
class OrderItemDataList extends AbstractStructBase
{
    /**
     * The item
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\OrderSearchData[]
     */
    public $item;
    /**
     * Constructor method for OrderItemDataList
     * @uses OrderItemDataList::setItem()
     * @param \StructType\OrderSearchData[] $item
     */
    public function __construct(array $item = array())
    {
        $this
            ->setItem($item);
    }
    /**
     * Get item value
     * @return \StructType\OrderSearchData[]|null
     */
    public function getItem()
    {
        return $this->item;
    }
    /**
     * Set item value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderSearchData[] $item
     * @return \StructType\OrderItemDataList
     */
    public function setItem(array $item = array())
    {
        foreach ($item as $orderItemDataListItemItem) {
            // validation for constraint: itemType
            if (!$orderItemDataListItemItem instanceof \StructType\OrderSearchData) {
                throw new \InvalidArgumentException(sprintf('The item property can only contain items of \StructType\OrderSearchData, "%s" given', is_object($orderItemDataListItemItem) ? get_class($orderItemDataListItemItem) : gettype($orderItemDataListItemItem)), __LINE__);
            }
        }
        $this->item = $item;
        return $this;
    }
    /**
     * Add item to item value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderSearchData $item
     * @return \StructType\OrderItemDataList
     */
    public function addToItem(\StructType\OrderSearchData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrderSearchData) {
            throw new \InvalidArgumentException(sprintf('The item property can only contain items of \StructType\OrderSearchData, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->item[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OrderItemDataList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
