<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderDetailRequest StructType
 * @subpackage Structs
 */
class OrderDetailRequest extends AbstractStructBase
{
    /**
     * The auth
     * @var \StructType\Authentication
     */
    public $auth;
    /**
     * The orderRequest
     * @var \StructType\OrderDataRequest
     */
    public $orderRequest;
    /**
     * Constructor method for OrderDetailRequest
     * @uses OrderDetailRequest::setAuth()
     * @uses OrderDetailRequest::setOrderRequest()
     * @param \StructType\Authentication $auth
     * @param \StructType\OrderDataRequest $orderRequest
     */
    public function __construct(\StructType\Authentication $auth = null, \StructType\OrderDataRequest $orderRequest = null)
    {
        $this
            ->setAuth($auth)
            ->setOrderRequest($orderRequest);
    }
    /**
     * Get auth value
     * @return \StructType\Authentication|null
     */
    public function getAuth()
    {
        return $this->auth;
    }
    /**
     * Set auth value
     * @param \StructType\Authentication $auth
     * @return \StructType\OrderDetailRequest
     */
    public function setAuth(\StructType\Authentication $auth = null)
    {
        $this->auth = $auth;
        return $this;
    }
    /**
     * Get orderRequest value
     * @return \StructType\OrderDataRequest|null
     */
    public function getOrderRequest()
    {
        return $this->orderRequest;
    }
    /**
     * Set orderRequest value
     * @param \StructType\OrderDataRequest $orderRequest
     * @return \StructType\OrderDetailRequest
     */
    public function setOrderRequest(\StructType\OrderDataRequest $orderRequest = null)
    {
        $this->orderRequest = $orderRequest;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OrderDetailRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
