<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemWithComplementaryData StructType
 * @subpackage Structs
 */
class ItemWithComplementaryData extends AbstractStructBase
{
    /**
     * The sellerCode
     * @var string
     */
    public $sellerCode;
    /**
     * The productTitle
     * @var string
     */
    public $productTitle;
    /**
     * The category
     * @var string
     */
    public $category;
    /**
     * The price
     * @var float
     */
    public $price;
    /**
     * The paidDate
     * @var string
     */
    public $paidDate;
    /**
     * The acceptedDate
     * @var string
     */
    public $acceptedDate;
    /**
     * The status
     * @var int
     */
    public $status;
    /**
     * The certificateNo
     * @var string
     */
    public $certificateNo;
    /**
     * The compItemId
     * @var int
     */
    public $compItemId;
    /**
     * The compAcceptedDate
     * @var string
     */
    public $compAcceptedDate;
    /**
     * The buyerAddress
     * @var \StructType\BuyerAddressData
     */
    public $buyerAddress;
    /**
     * Constructor method for ItemWithComplementaryData
     * @uses ItemWithComplementaryData::setSellerCode()
     * @uses ItemWithComplementaryData::setProductTitle()
     * @uses ItemWithComplementaryData::setCategory()
     * @uses ItemWithComplementaryData::setPrice()
     * @uses ItemWithComplementaryData::setPaidDate()
     * @uses ItemWithComplementaryData::setAcceptedDate()
     * @uses ItemWithComplementaryData::setStatus()
     * @uses ItemWithComplementaryData::setCertificateNo()
     * @uses ItemWithComplementaryData::setCompItemId()
     * @uses ItemWithComplementaryData::setCompAcceptedDate()
     * @uses ItemWithComplementaryData::setBuyerAddress()
     * @param string $sellerCode
     * @param string $productTitle
     * @param string $category
     * @param float $price
     * @param string $paidDate
     * @param string $acceptedDate
     * @param int $status
     * @param string $certificateNo
     * @param int $compItemId
     * @param string $compAcceptedDate
     * @param \StructType\BuyerAddressData $buyerAddress
     */
    public function __construct($sellerCode = null, $productTitle = null, $category = null, $price = null, $paidDate = null, $acceptedDate = null, $status = null, $certificateNo = null, $compItemId = null, $compAcceptedDate = null, \StructType\BuyerAddressData $buyerAddress = null)
    {
        $this
            ->setSellerCode($sellerCode)
            ->setProductTitle($productTitle)
            ->setCategory($category)
            ->setPrice($price)
            ->setPaidDate($paidDate)
            ->setAcceptedDate($acceptedDate)
            ->setStatus($status)
            ->setCertificateNo($certificateNo)
            ->setCompItemId($compItemId)
            ->setCompAcceptedDate($compAcceptedDate)
            ->setBuyerAddress($buyerAddress);
    }
    /**
     * Get sellerCode value
     * @return string|null
     */
    public function getSellerCode()
    {
        return $this->sellerCode;
    }
    /**
     * Set sellerCode value
     * @param string $sellerCode
     * @return \StructType\ItemWithComplementaryData
     */
    public function setSellerCode($sellerCode = null)
    {
        // validation for constraint: string
        if (!is_null($sellerCode) && !is_string($sellerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sellerCode)), __LINE__);
        }
        $this->sellerCode = $sellerCode;
        return $this;
    }
    /**
     * Get productTitle value
     * @return string|null
     */
    public function getProductTitle()
    {
        return $this->productTitle;
    }
    /**
     * Set productTitle value
     * @param string $productTitle
     * @return \StructType\ItemWithComplementaryData
     */
    public function setProductTitle($productTitle = null)
    {
        // validation for constraint: string
        if (!is_null($productTitle) && !is_string($productTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productTitle)), __LINE__);
        }
        $this->productTitle = $productTitle;
        return $this;
    }
    /**
     * Get category value
     * @return string|null
     */
    public function getCategory()
    {
        return $this->category;
    }
    /**
     * Set category value
     * @param string $category
     * @return \StructType\ItemWithComplementaryData
     */
    public function setCategory($category = null)
    {
        // validation for constraint: string
        if (!is_null($category) && !is_string($category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($category)), __LINE__);
        }
        $this->category = $category;
        return $this;
    }
    /**
     * Get price value
     * @return float|null
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * Set price value
     * @param float $price
     * @return \StructType\ItemWithComplementaryData
     */
    public function setPrice($price = null)
    {
        $this->price = $price;
        return $this;
    }
    /**
     * Get paidDate value
     * @return string|null
     */
    public function getPaidDate()
    {
        return $this->paidDate;
    }
    /**
     * Set paidDate value
     * @param string $paidDate
     * @return \StructType\ItemWithComplementaryData
     */
    public function setPaidDate($paidDate = null)
    {
        // validation for constraint: string
        if (!is_null($paidDate) && !is_string($paidDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paidDate)), __LINE__);
        }
        $this->paidDate = $paidDate;
        return $this;
    }
    /**
     * Get acceptedDate value
     * @return string|null
     */
    public function getAcceptedDate()
    {
        return $this->acceptedDate;
    }
    /**
     * Set acceptedDate value
     * @param string $acceptedDate
     * @return \StructType\ItemWithComplementaryData
     */
    public function setAcceptedDate($acceptedDate = null)
    {
        // validation for constraint: string
        if (!is_null($acceptedDate) && !is_string($acceptedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($acceptedDate)), __LINE__);
        }
        $this->acceptedDate = $acceptedDate;
        return $this;
    }
    /**
     * Get status value
     * @return int|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param int $status
     * @return \StructType\ItemWithComplementaryData
     */
    public function setStatus($status = null)
    {
        // validation for constraint: int
        if (!is_null($status) && !is_numeric($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get certificateNo value
     * @return string|null
     */
    public function getCertificateNo()
    {
        return $this->certificateNo;
    }
    /**
     * Set certificateNo value
     * @param string $certificateNo
     * @return \StructType\ItemWithComplementaryData
     */
    public function setCertificateNo($certificateNo = null)
    {
        // validation for constraint: string
        if (!is_null($certificateNo) && !is_string($certificateNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($certificateNo)), __LINE__);
        }
        $this->certificateNo = $certificateNo;
        return $this;
    }
    /**
     * Get compItemId value
     * @return int|null
     */
    public function getCompItemId()
    {
        return $this->compItemId;
    }
    /**
     * Set compItemId value
     * @param int $compItemId
     * @return \StructType\ItemWithComplementaryData
     */
    public function setCompItemId($compItemId = null)
    {
        // validation for constraint: int
        if (!is_null($compItemId) && !is_numeric($compItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($compItemId)), __LINE__);
        }
        $this->compItemId = $compItemId;
        return $this;
    }
    /**
     * Get compAcceptedDate value
     * @return string|null
     */
    public function getCompAcceptedDate()
    {
        return $this->compAcceptedDate;
    }
    /**
     * Set compAcceptedDate value
     * @param string $compAcceptedDate
     * @return \StructType\ItemWithComplementaryData
     */
    public function setCompAcceptedDate($compAcceptedDate = null)
    {
        // validation for constraint: string
        if (!is_null($compAcceptedDate) && !is_string($compAcceptedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($compAcceptedDate)), __LINE__);
        }
        $this->compAcceptedDate = $compAcceptedDate;
        return $this;
    }
    /**
     * Get buyerAddress value
     * @return \StructType\BuyerAddressData|null
     */
    public function getBuyerAddress()
    {
        return $this->buyerAddress;
    }
    /**
     * Set buyerAddress value
     * @param \StructType\BuyerAddressData $buyerAddress
     * @return \StructType\ItemWithComplementaryData
     */
    public function setBuyerAddress(\StructType\BuyerAddressData $buyerAddress = null)
    {
        $this->buyerAddress = $buyerAddress;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ItemWithComplementaryData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
