<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderItemListShipmentRequest StructType
 * @subpackage Structs
 */
class OrderItemListShipmentRequest extends AbstractStructBase
{
    /**
     * The orderItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\OrderItemShipmentRequest[]
     */
    public $orderItem;
    /**
     * Constructor method for OrderItemListShipmentRequest
     * @uses OrderItemListShipmentRequest::setOrderItem()
     * @param \StructType\OrderItemShipmentRequest[] $orderItem
     */
    public function __construct(array $orderItem = array())
    {
        $this
            ->setOrderItem($orderItem);
    }
    /**
     * Get orderItem value
     * @return \StructType\OrderItemShipmentRequest[]|null
     */
    public function getOrderItem()
    {
        return $this->orderItem;
    }
    /**
     * Set orderItem value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderItemShipmentRequest[] $orderItem
     * @return \StructType\OrderItemListShipmentRequest
     */
    public function setOrderItem(array $orderItem = array())
    {
        foreach ($orderItem as $orderItemListShipmentRequestOrderItemItem) {
            // validation for constraint: itemType
            if (!$orderItemListShipmentRequestOrderItemItem instanceof \StructType\OrderItemShipmentRequest) {
                throw new \InvalidArgumentException(sprintf('The orderItem property can only contain items of \StructType\OrderItemShipmentRequest, "%s" given', is_object($orderItemListShipmentRequestOrderItemItem) ? get_class($orderItemListShipmentRequestOrderItemItem) : gettype($orderItemListShipmentRequestOrderItemItem)), __LINE__);
            }
        }
        $this->orderItem = $orderItem;
        return $this;
    }
    /**
     * Add item to orderItem value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderItemShipmentRequest $item
     * @return \StructType\OrderItemListShipmentRequest
     */
    public function addToOrderItem(\StructType\OrderItemShipmentRequest $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrderItemShipmentRequest) {
            throw new \InvalidArgumentException(sprintf('The orderItem property can only contain items of \StructType\OrderItemShipmentRequest, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->orderItem[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OrderItemListShipmentRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
