<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderData StructType
 * @subpackage Structs
 */
class OrderData extends AbstractStructBase
{
    /**
     * The id
     * @var int
     */
    public $id;
    /**
     * The createDate
     * @var string
     */
    public $createDate;
    /**
     * The totalDiscountAmount
     * @var float
     */
    public $totalDiscountAmount;
    /**
     * The paymentType
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $paymentType;
    /**
     * The orderNumber
     * @var string
     */
    public $orderNumber;
    /**
     * The totalAmount
     * @var float
     */
    public $totalAmount;
    /**
     * The status
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $status;
    /**
     * The citizenshipId
     * @var string
     */
    public $citizenshipId;
    /**
     * Constructor method for OrderData
     * @uses OrderData::setId()
     * @uses OrderData::setCreateDate()
     * @uses OrderData::setTotalDiscountAmount()
     * @uses OrderData::setPaymentType()
     * @uses OrderData::setOrderNumber()
     * @uses OrderData::setTotalAmount()
     * @uses OrderData::setStatus()
     * @uses OrderData::setCitizenshipId()
     * @param int $id
     * @param string $createDate
     * @param float $totalDiscountAmount
     * @param int $paymentType
     * @param string $orderNumber
     * @param float $totalAmount
     * @param int $status
     * @param string $citizenshipId
     */
    public function __construct($id = null, $createDate = null, $totalDiscountAmount = null, $paymentType = null, $orderNumber = null, $totalAmount = null, $status = null, $citizenshipId = null)
    {
        $this
            ->setId($id)
            ->setCreateDate($createDate)
            ->setTotalDiscountAmount($totalDiscountAmount)
            ->setPaymentType($paymentType)
            ->setOrderNumber($orderNumber)
            ->setTotalAmount($totalAmount)
            ->setStatus($status)
            ->setCitizenshipId($citizenshipId);
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\OrderData
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !is_numeric($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get createDate value
     * @return string|null
     */
    public function getCreateDate()
    {
        return $this->createDate;
    }
    /**
     * Set createDate value
     * @param string $createDate
     * @return \StructType\OrderData
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createDate)), __LINE__);
        }
        $this->createDate = $createDate;
        return $this;
    }
    /**
     * Get totalDiscountAmount value
     * @return float|null
     */
    public function getTotalDiscountAmount()
    {
        return $this->totalDiscountAmount;
    }
    /**
     * Set totalDiscountAmount value
     * @param float $totalDiscountAmount
     * @return \StructType\OrderData
     */
    public function setTotalDiscountAmount($totalDiscountAmount = null)
    {
        $this->totalDiscountAmount = $totalDiscountAmount;
        return $this;
    }
    /**
     * Get paymentType value
     * @return int|null
     */
    public function getPaymentType()
    {
        return $this->paymentType;
    }
    /**
     * Set paymentType value
     * @param int $paymentType
     * @return \StructType\OrderData
     */
    public function setPaymentType($paymentType = null)
    {
        // validation for constraint: int
        if (!is_null($paymentType) && !is_numeric($paymentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($paymentType)), __LINE__);
        }
        $this->paymentType = $paymentType;
        return $this;
    }
    /**
     * Get orderNumber value
     * @return string|null
     */
    public function getOrderNumber()
    {
        return $this->orderNumber;
    }
    /**
     * Set orderNumber value
     * @param string $orderNumber
     * @return \StructType\OrderData
     */
    public function setOrderNumber($orderNumber = null)
    {
        // validation for constraint: string
        if (!is_null($orderNumber) && !is_string($orderNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderNumber)), __LINE__);
        }
        $this->orderNumber = $orderNumber;
        return $this;
    }
    /**
     * Get totalAmount value
     * @return float|null
     */
    public function getTotalAmount()
    {
        return $this->totalAmount;
    }
    /**
     * Set totalAmount value
     * @param float $totalAmount
     * @return \StructType\OrderData
     */
    public function setTotalAmount($totalAmount = null)
    {
        $this->totalAmount = $totalAmount;
        return $this;
    }
    /**
     * Get status value
     * @return int|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param int $status
     * @return \StructType\OrderData
     */
    public function setStatus($status = null)
    {
        // validation for constraint: int
        if (!is_null($status) && !is_numeric($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get citizenshipId value
     * @return string|null
     */
    public function getCitizenshipId()
    {
        return $this->citizenshipId;
    }
    /**
     * Set citizenshipId value
     * @param string $citizenshipId
     * @return \StructType\OrderData
     */
    public function setCitizenshipId($citizenshipId = null)
    {
        // validation for constraint: string
        if (!is_null($citizenshipId) && !is_string($citizenshipId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($citizenshipId)), __LINE__);
        }
        $this->citizenshipId = $citizenshipId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OrderData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
